/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loganalytics.model.AbstractCommandDescriptor;
import com.oracle.bmc.loganalytics.model.AbstractField;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="name")
@JsonFilter(value="explicitlySetFilter")
public final class LinkCommandDescriptor
extends AbstractCommandDescriptor {
    @JsonProperty(value="shouldIncludeNulls")
    private final Boolean shouldIncludeNulls;
    @JsonProperty(value="shouldIncludeTrends")
    private final Boolean shouldIncludeTrends;
    @JsonProperty(value="span")
    private final String span;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public LinkCommandDescriptor(String displayQueryString, String internalQueryString, String category, List<AbstractField> referencedFields, List<AbstractField> declaredFields, Boolean isHidden, Boolean shouldIncludeNulls, Boolean shouldIncludeTrends, String span) {
        super(displayQueryString, internalQueryString, category, referencedFields, declaredFields, isHidden);
        this.shouldIncludeNulls = shouldIncludeNulls;
        this.shouldIncludeTrends = shouldIncludeTrends;
        this.span = span;
    }

    public Boolean getShouldIncludeNulls() {
        return this.shouldIncludeNulls;
    }

    public Boolean getShouldIncludeTrends() {
        return this.shouldIncludeTrends;
    }

    public String getSpan() {
        return this.span;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LinkCommandDescriptor(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", shouldIncludeNulls=").append(String.valueOf(this.shouldIncludeNulls));
        sb.append(", shouldIncludeTrends=").append(String.valueOf(this.shouldIncludeTrends));
        sb.append(", span=").append(String.valueOf(this.span));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LinkCommandDescriptor)) {
            return false;
        }
        LinkCommandDescriptor other = (LinkCommandDescriptor)((Object)o);
        return Objects.equals(this.shouldIncludeNulls, other.shouldIncludeNulls) && Objects.equals(this.shouldIncludeTrends, other.shouldIncludeTrends) && Objects.equals(this.span, other.span) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.shouldIncludeNulls == null ? 43 : this.shouldIncludeNulls.hashCode());
        result = result * 59 + (this.shouldIncludeTrends == null ? 43 : this.shouldIncludeTrends.hashCode());
        result = result * 59 + (this.span == null ? 43 : this.span.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayQueryString")
        private String displayQueryString;
        @JsonProperty(value="internalQueryString")
        private String internalQueryString;
        @JsonProperty(value="category")
        private String category;
        @JsonProperty(value="referencedFields")
        private List<AbstractField> referencedFields;
        @JsonProperty(value="declaredFields")
        private List<AbstractField> declaredFields;
        @JsonProperty(value="isHidden")
        private Boolean isHidden;
        @JsonProperty(value="shouldIncludeNulls")
        private Boolean shouldIncludeNulls;
        @JsonProperty(value="shouldIncludeTrends")
        private Boolean shouldIncludeTrends;
        @JsonProperty(value="span")
        private String span;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayQueryString(String displayQueryString) {
            this.displayQueryString = displayQueryString;
            this.__explicitlySet__.add("displayQueryString");
            return this;
        }

        public Builder internalQueryString(String internalQueryString) {
            this.internalQueryString = internalQueryString;
            this.__explicitlySet__.add("internalQueryString");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder referencedFields(List<AbstractField> referencedFields) {
            this.referencedFields = referencedFields;
            this.__explicitlySet__.add("referencedFields");
            return this;
        }

        public Builder declaredFields(List<AbstractField> declaredFields) {
            this.declaredFields = declaredFields;
            this.__explicitlySet__.add("declaredFields");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.__explicitlySet__.add("isHidden");
            return this;
        }

        public Builder shouldIncludeNulls(Boolean shouldIncludeNulls) {
            this.shouldIncludeNulls = shouldIncludeNulls;
            this.__explicitlySet__.add("shouldIncludeNulls");
            return this;
        }

        public Builder shouldIncludeTrends(Boolean shouldIncludeTrends) {
            this.shouldIncludeTrends = shouldIncludeTrends;
            this.__explicitlySet__.add("shouldIncludeTrends");
            return this;
        }

        public Builder span(String span) {
            this.span = span;
            this.__explicitlySet__.add("span");
            return this;
        }

        public LinkCommandDescriptor build() {
            LinkCommandDescriptor model = new LinkCommandDescriptor(this.displayQueryString, this.internalQueryString, this.category, this.referencedFields, this.declaredFields, this.isHidden, this.shouldIncludeNulls, this.shouldIncludeTrends, this.span);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LinkCommandDescriptor model) {
            if (model.wasPropertyExplicitlySet("displayQueryString")) {
                this.displayQueryString(model.getDisplayQueryString());
            }
            if (model.wasPropertyExplicitlySet("internalQueryString")) {
                this.internalQueryString(model.getInternalQueryString());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("referencedFields")) {
                this.referencedFields(model.getReferencedFields());
            }
            if (model.wasPropertyExplicitlySet("declaredFields")) {
                this.declaredFields(model.getDeclaredFields());
            }
            if (model.wasPropertyExplicitlySet("isHidden")) {
                this.isHidden(model.getIsHidden());
            }
            if (model.wasPropertyExplicitlySet("shouldIncludeNulls")) {
                this.shouldIncludeNulls(model.getShouldIncludeNulls());
            }
            if (model.wasPropertyExplicitlySet("shouldIncludeTrends")) {
                this.shouldIncludeTrends(model.getShouldIncludeTrends());
            }
            if (model.wasPropertyExplicitlySet("span")) {
                this.span(model.getSpan());
            }
            return this;
        }
    }
}

