/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.IngestTimeRuleAdditionalFieldCondition;
import com.oracle.bmc.loganalytics.model.IngestTimeRuleCondition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonFilter(value="explicitlySetFilter")
public final class IngestTimeRuleFieldCondition
extends IngestTimeRuleCondition {
    @JsonProperty(value="fieldName")
    private final String fieldName;
    @JsonProperty(value="fieldOperator")
    private final FieldOperator fieldOperator;
    @JsonProperty(value="fieldValue")
    private final String fieldValue;
    @JsonProperty(value="additionalConditions")
    private final List<IngestTimeRuleAdditionalFieldCondition> additionalConditions;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public IngestTimeRuleFieldCondition(String fieldName, FieldOperator fieldOperator, String fieldValue, List<IngestTimeRuleAdditionalFieldCondition> additionalConditions) {
        this.fieldName = fieldName;
        this.fieldOperator = fieldOperator;
        this.fieldValue = fieldValue;
        this.additionalConditions = additionalConditions;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public FieldOperator getFieldOperator() {
        return this.fieldOperator;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public List<IngestTimeRuleAdditionalFieldCondition> getAdditionalConditions() {
        return this.additionalConditions;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IngestTimeRuleFieldCondition(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", fieldName=").append(String.valueOf(this.fieldName));
        sb.append(", fieldOperator=").append(String.valueOf((Object)this.fieldOperator));
        sb.append(", fieldValue=").append(String.valueOf(this.fieldValue));
        sb.append(", additionalConditions=").append(String.valueOf(this.additionalConditions));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IngestTimeRuleFieldCondition)) {
            return false;
        }
        IngestTimeRuleFieldCondition other = (IngestTimeRuleFieldCondition)((Object)o);
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals((Object)this.fieldOperator, (Object)other.fieldOperator) && Objects.equals(this.fieldValue, other.fieldValue) && Objects.equals(this.additionalConditions, other.additionalConditions) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fieldName == null ? 43 : this.fieldName.hashCode());
        result = result * 59 + (this.fieldOperator == null ? 43 : this.fieldOperator.hashCode());
        result = result * 59 + (this.fieldValue == null ? 43 : this.fieldValue.hashCode());
        result = result * 59 + (this.additionalConditions == null ? 43 : this.additionalConditions.hashCode());
        return result;
    }

    public static enum FieldOperator implements BmcEnum
    {
        Equal("EQUAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, FieldOperator> map;

        private FieldOperator(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FieldOperator create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'FieldOperator', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(FieldOperator.class);
            map = new HashMap<String, FieldOperator>();
            for (FieldOperator v : FieldOperator.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fieldName")
        private String fieldName;
        @JsonProperty(value="fieldOperator")
        private FieldOperator fieldOperator;
        @JsonProperty(value="fieldValue")
        private String fieldValue;
        @JsonProperty(value="additionalConditions")
        private List<IngestTimeRuleAdditionalFieldCondition> additionalConditions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            this.__explicitlySet__.add("fieldName");
            return this;
        }

        public Builder fieldOperator(FieldOperator fieldOperator) {
            this.fieldOperator = fieldOperator;
            this.__explicitlySet__.add("fieldOperator");
            return this;
        }

        public Builder fieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
            this.__explicitlySet__.add("fieldValue");
            return this;
        }

        public Builder additionalConditions(List<IngestTimeRuleAdditionalFieldCondition> additionalConditions) {
            this.additionalConditions = additionalConditions;
            this.__explicitlySet__.add("additionalConditions");
            return this;
        }

        public IngestTimeRuleFieldCondition build() {
            IngestTimeRuleFieldCondition model = new IngestTimeRuleFieldCondition(this.fieldName, this.fieldOperator, this.fieldValue, this.additionalConditions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IngestTimeRuleFieldCondition model) {
            if (model.wasPropertyExplicitlySet("fieldName")) {
                this.fieldName(model.getFieldName());
            }
            if (model.wasPropertyExplicitlySet("fieldOperator")) {
                this.fieldOperator(model.getFieldOperator());
            }
            if (model.wasPropertyExplicitlySet("fieldValue")) {
                this.fieldValue(model.getFieldValue());
            }
            if (model.wasPropertyExplicitlySet("additionalConditions")) {
                this.additionalConditions(model.getAdditionalConditions());
            }
            return this;
        }
    }
}

