/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FieldValue
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayValue")
    private final String displayValue;
    @JsonProperty(value="internalValue")
    private final Object internalValue;
    @JsonProperty(value="isDeleted")
    private final Boolean isDeleted;

    @Deprecated
    @ConstructorProperties(value={"displayValue", "internalValue", "isDeleted"})
    public FieldValue(String displayValue, Object internalValue, Boolean isDeleted) {
        this.displayValue = displayValue;
        this.internalValue = internalValue;
        this.isDeleted = isDeleted;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public Object getInternalValue() {
        return this.internalValue;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FieldValue(");
        sb.append("super=").append(super.toString());
        sb.append("displayValue=").append(String.valueOf(this.displayValue));
        sb.append(", internalValue=").append(String.valueOf(this.internalValue));
        sb.append(", isDeleted=").append(String.valueOf(this.isDeleted));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldValue)) {
            return false;
        }
        FieldValue other = (FieldValue)((Object)o);
        return Objects.equals(this.displayValue, other.displayValue) && Objects.equals(this.internalValue, other.internalValue) && Objects.equals(this.isDeleted, other.isDeleted) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayValue == null ? 43 : this.displayValue.hashCode());
        result = result * 59 + (this.internalValue == null ? 43 : this.internalValue.hashCode());
        result = result * 59 + (this.isDeleted == null ? 43 : this.isDeleted.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayValue")
        private String displayValue;
        @JsonProperty(value="internalValue")
        private Object internalValue;
        @JsonProperty(value="isDeleted")
        private Boolean isDeleted;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayValue(String displayValue) {
            this.displayValue = displayValue;
            this.__explicitlySet__.add("displayValue");
            return this;
        }

        public Builder internalValue(Object internalValue) {
            this.internalValue = internalValue;
            this.__explicitlySet__.add("internalValue");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.__explicitlySet__.add("isDeleted");
            return this;
        }

        public FieldValue build() {
            FieldValue model = new FieldValue(this.displayValue, this.internalValue, this.isDeleted);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FieldValue model) {
            if (model.wasPropertyExplicitlySet("displayValue")) {
                this.displayValue(model.getDisplayValue());
            }
            if (model.wasPropertyExplicitlySet("internalValue")) {
                this.internalValue(model.getInternalValue());
            }
            if (model.wasPropertyExplicitlySet("isDeleted")) {
                this.isDeleted(model.getIsDeleted());
            }
            return this;
        }
    }
}

