/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loganalytics.model.AbstractCommandDescriptor;
import com.oracle.bmc.loganalytics.model.AbstractField;
import com.oracle.bmc.loganalytics.model.BucketRange;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="name")
@JsonFilter(value="explicitlySetFilter")
public final class BucketCommandDescriptor
extends AbstractCommandDescriptor {
    @JsonProperty(value="maxBuckets")
    private final Integer maxBuckets;
    @JsonProperty(value="span")
    private final BigDecimal span;
    @JsonProperty(value="ranges")
    private final List<BucketRange> ranges;
    @JsonProperty(value="defaultValue")
    private final String defaultValue;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public BucketCommandDescriptor(String displayQueryString, String internalQueryString, String category, List<AbstractField> referencedFields, List<AbstractField> declaredFields, Boolean isHidden, Integer maxBuckets, BigDecimal span, List<BucketRange> ranges, String defaultValue) {
        super(displayQueryString, internalQueryString, category, referencedFields, declaredFields, isHidden);
        this.maxBuckets = maxBuckets;
        this.span = span;
        this.ranges = ranges;
        this.defaultValue = defaultValue;
    }

    public Integer getMaxBuckets() {
        return this.maxBuckets;
    }

    public BigDecimal getSpan() {
        return this.span;
    }

    public List<BucketRange> getRanges() {
        return this.ranges;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BucketCommandDescriptor(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", maxBuckets=").append(String.valueOf(this.maxBuckets));
        sb.append(", span=").append(String.valueOf(this.span));
        sb.append(", ranges=").append(String.valueOf(this.ranges));
        sb.append(", defaultValue=").append(String.valueOf(this.defaultValue));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BucketCommandDescriptor)) {
            return false;
        }
        BucketCommandDescriptor other = (BucketCommandDescriptor)((Object)o);
        return Objects.equals(this.maxBuckets, other.maxBuckets) && Objects.equals(this.span, other.span) && Objects.equals(this.ranges, other.ranges) && Objects.equals(this.defaultValue, other.defaultValue) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maxBuckets == null ? 43 : this.maxBuckets.hashCode());
        result = result * 59 + (this.span == null ? 43 : this.span.hashCode());
        result = result * 59 + (this.ranges == null ? 43 : this.ranges.hashCode());
        result = result * 59 + (this.defaultValue == null ? 43 : this.defaultValue.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayQueryString")
        private String displayQueryString;
        @JsonProperty(value="internalQueryString")
        private String internalQueryString;
        @JsonProperty(value="category")
        private String category;
        @JsonProperty(value="referencedFields")
        private List<AbstractField> referencedFields;
        @JsonProperty(value="declaredFields")
        private List<AbstractField> declaredFields;
        @JsonProperty(value="isHidden")
        private Boolean isHidden;
        @JsonProperty(value="maxBuckets")
        private Integer maxBuckets;
        @JsonProperty(value="span")
        private BigDecimal span;
        @JsonProperty(value="ranges")
        private List<BucketRange> ranges;
        @JsonProperty(value="defaultValue")
        private String defaultValue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayQueryString(String displayQueryString) {
            this.displayQueryString = displayQueryString;
            this.__explicitlySet__.add("displayQueryString");
            return this;
        }

        public Builder internalQueryString(String internalQueryString) {
            this.internalQueryString = internalQueryString;
            this.__explicitlySet__.add("internalQueryString");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder referencedFields(List<AbstractField> referencedFields) {
            this.referencedFields = referencedFields;
            this.__explicitlySet__.add("referencedFields");
            return this;
        }

        public Builder declaredFields(List<AbstractField> declaredFields) {
            this.declaredFields = declaredFields;
            this.__explicitlySet__.add("declaredFields");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.__explicitlySet__.add("isHidden");
            return this;
        }

        public Builder maxBuckets(Integer maxBuckets) {
            this.maxBuckets = maxBuckets;
            this.__explicitlySet__.add("maxBuckets");
            return this;
        }

        public Builder span(BigDecimal span) {
            this.span = span;
            this.__explicitlySet__.add("span");
            return this;
        }

        public Builder ranges(List<BucketRange> ranges) {
            this.ranges = ranges;
            this.__explicitlySet__.add("ranges");
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            this.__explicitlySet__.add("defaultValue");
            return this;
        }

        public BucketCommandDescriptor build() {
            BucketCommandDescriptor model = new BucketCommandDescriptor(this.displayQueryString, this.internalQueryString, this.category, this.referencedFields, this.declaredFields, this.isHidden, this.maxBuckets, this.span, this.ranges, this.defaultValue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BucketCommandDescriptor model) {
            if (model.wasPropertyExplicitlySet("displayQueryString")) {
                this.displayQueryString(model.getDisplayQueryString());
            }
            if (model.wasPropertyExplicitlySet("internalQueryString")) {
                this.internalQueryString(model.getInternalQueryString());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("referencedFields")) {
                this.referencedFields(model.getReferencedFields());
            }
            if (model.wasPropertyExplicitlySet("declaredFields")) {
                this.declaredFields(model.getDeclaredFields());
            }
            if (model.wasPropertyExplicitlySet("isHidden")) {
                this.isHidden(model.getIsHidden());
            }
            if (model.wasPropertyExplicitlySet("maxBuckets")) {
                this.maxBuckets(model.getMaxBuckets());
            }
            if (model.wasPropertyExplicitlySet("span")) {
                this.span(model.getSpan());
            }
            if (model.wasPropertyExplicitlySet("ranges")) {
                this.ranges(model.getRanges());
            }
            if (model.wasPropertyExplicitlySet("defaultValue")) {
                this.defaultValue(model.getDefaultValue());
            }
            return this;
        }
    }
}

