/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.lockbox.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetApprovalTemplateRequest
extends BmcRequest<Void> {
    private String approvalTemplateId;
    private String opcRequestId;

    public String getApprovalTemplateId() {
        return this.approvalTemplateId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().approvalTemplateId(this.approvalTemplateId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",approvalTemplateId=").append(String.valueOf(this.approvalTemplateId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetApprovalTemplateRequest)) {
            return false;
        }
        GetApprovalTemplateRequest other = (GetApprovalTemplateRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.approvalTemplateId, other.approvalTemplateId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.approvalTemplateId == null ? 43 : this.approvalTemplateId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetApprovalTemplateRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String approvalTemplateId = null;
        private String opcRequestId = null;

        public Builder approvalTemplateId(String approvalTemplateId) {
            this.approvalTemplateId = approvalTemplateId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetApprovalTemplateRequest o) {
            this.approvalTemplateId(o.getApprovalTemplateId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetApprovalTemplateRequest build() {
            GetApprovalTemplateRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetApprovalTemplateRequest buildWithoutInvocationCallback() {
            GetApprovalTemplateRequest request = new GetApprovalTemplateRequest();
            request.approvalTemplateId = this.approvalTemplateId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

