/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.lockbox;

import com.oracle.bmc.lockbox.Lockbox;
import com.oracle.bmc.lockbox.model.AccessRequest;
import com.oracle.bmc.lockbox.model.ApprovalTemplate;
import com.oracle.bmc.lockbox.model.Lockbox;
import com.oracle.bmc.lockbox.requests.GetAccessRequestRequest;
import com.oracle.bmc.lockbox.requests.GetApprovalTemplateRequest;
import com.oracle.bmc.lockbox.requests.GetLockboxRequest;
import com.oracle.bmc.lockbox.requests.GetWorkRequestRequest;
import com.oracle.bmc.lockbox.responses.GetAccessRequestResponse;
import com.oracle.bmc.lockbox.responses.GetApprovalTemplateResponse;
import com.oracle.bmc.lockbox.responses.GetLockboxResponse;
import com.oracle.bmc.lockbox.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class LockboxWaiters {
    private final ExecutorService executorService;
    private final Lockbox client;

    public LockboxWaiters(ExecutorService executorService, Lockbox client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAccessRequestRequest, GetAccessRequestResponse> forAccessRequest(GetAccessRequestRequest request, AccessRequest.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAccessRequest(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAccessRequestRequest, GetAccessRequestResponse> forAccessRequest(GetAccessRequestRequest request, AccessRequest.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAccessRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAccessRequestRequest, GetAccessRequestResponse> forAccessRequest(GetAccessRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AccessRequest.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAccessRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAccessRequestRequest, GetAccessRequestResponse> forAccessRequest(BmcGenericWaiter waiter, GetAccessRequestRequest request, AccessRequest.LifecycleState ... targetStates) {
        final HashSet<AccessRequest.LifecycleState> targetStatesSet = new HashSet<AccessRequest.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAccessRequestRequest, GetAccessRequestResponse>(){

            @Override
            public GetAccessRequestResponse apply(GetAccessRequestRequest request) {
                return LockboxWaiters.this.client.getAccessRequest(request);
            }
        }, (Predicate)new Predicate<GetAccessRequestResponse>(){

            @Override
            public boolean test(GetAccessRequestResponse response) {
                return targetStatesSet.contains((Object)response.getAccessRequest().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetApprovalTemplateRequest, GetApprovalTemplateResponse> forApprovalTemplate(GetApprovalTemplateRequest request, ApprovalTemplate.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forApprovalTemplate(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetApprovalTemplateRequest, GetApprovalTemplateResponse> forApprovalTemplate(GetApprovalTemplateRequest request, ApprovalTemplate.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forApprovalTemplate(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetApprovalTemplateRequest, GetApprovalTemplateResponse> forApprovalTemplate(GetApprovalTemplateRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ApprovalTemplate.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forApprovalTemplate(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetApprovalTemplateRequest, GetApprovalTemplateResponse> forApprovalTemplate(BmcGenericWaiter waiter, GetApprovalTemplateRequest request, ApprovalTemplate.LifecycleState ... targetStates) {
        final HashSet<ApprovalTemplate.LifecycleState> targetStatesSet = new HashSet<ApprovalTemplate.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetApprovalTemplateRequest, GetApprovalTemplateResponse>(){

            @Override
            public GetApprovalTemplateResponse apply(GetApprovalTemplateRequest request) {
                return LockboxWaiters.this.client.getApprovalTemplate(request);
            }
        }, (Predicate)new Predicate<GetApprovalTemplateResponse>(){

            @Override
            public boolean test(GetApprovalTemplateResponse response) {
                return targetStatesSet.contains((Object)response.getApprovalTemplate().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ApprovalTemplate.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetLockboxRequest, GetLockboxResponse> forLockbox(GetLockboxRequest request, Lockbox.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLockbox(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetLockboxRequest, GetLockboxResponse> forLockbox(GetLockboxRequest request, Lockbox.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forLockbox(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetLockboxRequest, GetLockboxResponse> forLockbox(GetLockboxRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Lockbox.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forLockbox(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetLockboxRequest, GetLockboxResponse> forLockbox(BmcGenericWaiter waiter, GetLockboxRequest request, Lockbox.LifecycleState ... targetStates) {
        final HashSet<Lockbox.LifecycleState> targetStatesSet = new HashSet<Lockbox.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetLockboxRequest, GetLockboxResponse>(){

            @Override
            public GetLockboxResponse apply(GetLockboxRequest request) {
                return LockboxWaiters.this.client.getLockbox(request);
            }
        }, (Predicate)new Predicate<GetLockboxResponse>(){

            @Override
            public boolean test(GetLockboxResponse response) {
                return targetStatesSet.contains((Object)response.getLockbox().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Lockbox.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return LockboxWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

