/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loadbalancer.model.PathMatchType;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PathRoute
extends ExplicitlySetBmcModel {
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="pathMatchType")
    private final PathMatchType pathMatchType;
    @JsonProperty(value="backendSetName")
    private final String backendSetName;

    @Deprecated
    @ConstructorProperties(value={"path", "pathMatchType", "backendSetName"})
    public PathRoute(String path, PathMatchType pathMatchType, String backendSetName) {
        this.path = path;
        this.pathMatchType = pathMatchType;
        this.backendSetName = backendSetName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPath() {
        return this.path;
    }

    public PathMatchType getPathMatchType() {
        return this.pathMatchType;
    }

    public String getBackendSetName() {
        return this.backendSetName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PathRoute(");
        sb.append("super=").append(super.toString());
        sb.append("path=").append(String.valueOf(this.path));
        sb.append(", pathMatchType=").append(String.valueOf((Object)this.pathMatchType));
        sb.append(", backendSetName=").append(String.valueOf(this.backendSetName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathRoute)) {
            return false;
        }
        PathRoute other = (PathRoute)((Object)o);
        return Objects.equals(this.path, other.path) && Objects.equals((Object)this.pathMatchType, (Object)other.pathMatchType) && Objects.equals(this.backendSetName, other.backendSetName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.pathMatchType == null ? 43 : this.pathMatchType.hashCode());
        result = result * 59 + (this.backendSetName == null ? 43 : this.backendSetName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="pathMatchType")
        private PathMatchType pathMatchType;
        @JsonProperty(value="backendSetName")
        private String backendSetName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder pathMatchType(PathMatchType pathMatchType) {
            this.pathMatchType = pathMatchType;
            this.__explicitlySet__.add("pathMatchType");
            return this;
        }

        public Builder backendSetName(String backendSetName) {
            this.backendSetName = backendSetName;
            this.__explicitlySet__.add("backendSetName");
            return this;
        }

        public PathRoute build() {
            PathRoute model = new PathRoute(this.path, this.pathMatchType, this.backendSetName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PathRoute model) {
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("pathMatchType")) {
                this.pathMatchType(model.getPathMatchType());
            }
            if (model.wasPropertyExplicitlySet("backendSetName")) {
                this.backendSetName(model.getBackendSetName());
            }
            return this;
        }
    }
}

