/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loadbalancer.model.BackendSet;
import com.oracle.bmc.loadbalancer.model.Certificate;
import com.oracle.bmc.loadbalancer.model.Hostname;
import com.oracle.bmc.loadbalancer.model.IpAddress;
import com.oracle.bmc.loadbalancer.model.Listener;
import com.oracle.bmc.loadbalancer.model.PathRouteSet;
import com.oracle.bmc.loadbalancer.model.RoutingPolicy;
import com.oracle.bmc.loadbalancer.model.RuleSet;
import com.oracle.bmc.loadbalancer.model.SSLCipherSuite;
import com.oracle.bmc.loadbalancer.model.ShapeDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LoadBalancer
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="ipAddresses")
    private final List<IpAddress> ipAddresses;
    @JsonProperty(value="shapeName")
    private final String shapeName;
    @JsonProperty(value="shapeDetails")
    private final ShapeDetails shapeDetails;
    @JsonProperty(value="isPrivate")
    private final Boolean isPrivate;
    @JsonProperty(value="subnetIds")
    private final List<String> subnetIds;
    @JsonProperty(value="networkSecurityGroupIds")
    private final List<String> networkSecurityGroupIds;
    @JsonProperty(value="listeners")
    private final Map<String, Listener> listeners;
    @JsonProperty(value="hostnames")
    private final Map<String, Hostname> hostnames;
    @JsonProperty(value="sslCipherSuites")
    private final Map<String, SSLCipherSuite> sslCipherSuites;
    @JsonProperty(value="certificates")
    private final Map<String, Certificate> certificates;
    @JsonProperty(value="backendSets")
    private final Map<String, BackendSet> backendSets;
    @JsonProperty(value="pathRouteSets")
    private final Map<String, PathRouteSet> pathRouteSets;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="ruleSets")
    private final Map<String, RuleSet> ruleSets;
    @JsonProperty(value="routingPolicies")
    private final Map<String, RoutingPolicy> routingPolicies;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "lifecycleState", "timeCreated", "ipAddresses", "shapeName", "shapeDetails", "isPrivate", "subnetIds", "networkSecurityGroupIds", "listeners", "hostnames", "sslCipherSuites", "certificates", "backendSets", "pathRouteSets", "freeformTags", "definedTags", "systemTags", "ruleSets", "routingPolicies"})
    public LoadBalancer(String id, String compartmentId, String displayName, LifecycleState lifecycleState, Date timeCreated, List<IpAddress> ipAddresses, String shapeName, ShapeDetails shapeDetails, Boolean isPrivate, List<String> subnetIds, List<String> networkSecurityGroupIds, Map<String, Listener> listeners, Map<String, Hostname> hostnames, Map<String, SSLCipherSuite> sslCipherSuites, Map<String, Certificate> certificates, Map<String, BackendSet> backendSets, Map<String, PathRouteSet> pathRouteSets, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, Map<String, RuleSet> ruleSets, Map<String, RoutingPolicy> routingPolicies) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.ipAddresses = ipAddresses;
        this.shapeName = shapeName;
        this.shapeDetails = shapeDetails;
        this.isPrivate = isPrivate;
        this.subnetIds = subnetIds;
        this.networkSecurityGroupIds = networkSecurityGroupIds;
        this.listeners = listeners;
        this.hostnames = hostnames;
        this.sslCipherSuites = sslCipherSuites;
        this.certificates = certificates;
        this.backendSets = backendSets;
        this.pathRouteSets = pathRouteSets;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
        this.ruleSets = ruleSets;
        this.routingPolicies = routingPolicies;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public List<IpAddress> getIpAddresses() {
        return this.ipAddresses;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public ShapeDetails getShapeDetails() {
        return this.shapeDetails;
    }

    public Boolean getIsPrivate() {
        return this.isPrivate;
    }

    public List<String> getSubnetIds() {
        return this.subnetIds;
    }

    public List<String> getNetworkSecurityGroupIds() {
        return this.networkSecurityGroupIds;
    }

    public Map<String, Listener> getListeners() {
        return this.listeners;
    }

    public Map<String, Hostname> getHostnames() {
        return this.hostnames;
    }

    public Map<String, SSLCipherSuite> getSslCipherSuites() {
        return this.sslCipherSuites;
    }

    public Map<String, Certificate> getCertificates() {
        return this.certificates;
    }

    public Map<String, BackendSet> getBackendSets() {
        return this.backendSets;
    }

    public Map<String, PathRouteSet> getPathRouteSets() {
        return this.pathRouteSets;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public Map<String, RuleSet> getRuleSets() {
        return this.ruleSets;
    }

    public Map<String, RoutingPolicy> getRoutingPolicies() {
        return this.routingPolicies;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LoadBalancer(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", ipAddresses=").append(String.valueOf(this.ipAddresses));
        sb.append(", shapeName=").append(String.valueOf(this.shapeName));
        sb.append(", shapeDetails=").append(String.valueOf((Object)this.shapeDetails));
        sb.append(", isPrivate=").append(String.valueOf(this.isPrivate));
        sb.append(", subnetIds=").append(String.valueOf(this.subnetIds));
        sb.append(", networkSecurityGroupIds=").append(String.valueOf(this.networkSecurityGroupIds));
        sb.append(", listeners=").append(String.valueOf(this.listeners));
        sb.append(", hostnames=").append(String.valueOf(this.hostnames));
        sb.append(", sslCipherSuites=").append(String.valueOf(this.sslCipherSuites));
        sb.append(", certificates=").append(String.valueOf(this.certificates));
        sb.append(", backendSets=").append(String.valueOf(this.backendSets));
        sb.append(", pathRouteSets=").append(String.valueOf(this.pathRouteSets));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", ruleSets=").append(String.valueOf(this.ruleSets));
        sb.append(", routingPolicies=").append(String.valueOf(this.routingPolicies));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoadBalancer)) {
            return false;
        }
        LoadBalancer other = (LoadBalancer)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.ipAddresses, other.ipAddresses) && Objects.equals(this.shapeName, other.shapeName) && Objects.equals((Object)this.shapeDetails, (Object)other.shapeDetails) && Objects.equals(this.isPrivate, other.isPrivate) && Objects.equals(this.subnetIds, other.subnetIds) && Objects.equals(this.networkSecurityGroupIds, other.networkSecurityGroupIds) && Objects.equals(this.listeners, other.listeners) && Objects.equals(this.hostnames, other.hostnames) && Objects.equals(this.sslCipherSuites, other.sslCipherSuites) && Objects.equals(this.certificates, other.certificates) && Objects.equals(this.backendSets, other.backendSets) && Objects.equals(this.pathRouteSets, other.pathRouteSets) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals(this.ruleSets, other.ruleSets) && Objects.equals(this.routingPolicies, other.routingPolicies) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.ipAddresses == null ? 43 : this.ipAddresses.hashCode());
        result = result * 59 + (this.shapeName == null ? 43 : this.shapeName.hashCode());
        result = result * 59 + (this.shapeDetails == null ? 43 : this.shapeDetails.hashCode());
        result = result * 59 + (this.isPrivate == null ? 43 : this.isPrivate.hashCode());
        result = result * 59 + (this.subnetIds == null ? 43 : this.subnetIds.hashCode());
        result = result * 59 + (this.networkSecurityGroupIds == null ? 43 : this.networkSecurityGroupIds.hashCode());
        result = result * 59 + (this.listeners == null ? 43 : this.listeners.hashCode());
        result = result * 59 + (this.hostnames == null ? 43 : this.hostnames.hashCode());
        result = result * 59 + (this.sslCipherSuites == null ? 43 : this.sslCipherSuites.hashCode());
        result = result * 59 + (this.certificates == null ? 43 : this.certificates.hashCode());
        result = result * 59 + (this.backendSets == null ? 43 : this.backendSets.hashCode());
        result = result * 59 + (this.pathRouteSets == null ? 43 : this.pathRouteSets.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.ruleSets == null ? 43 : this.ruleSets.hashCode());
        result = result * 59 + (this.routingPolicies == null ? 43 : this.routingPolicies.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Failed("FAILED"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="ipAddresses")
        private List<IpAddress> ipAddresses;
        @JsonProperty(value="shapeName")
        private String shapeName;
        @JsonProperty(value="shapeDetails")
        private ShapeDetails shapeDetails;
        @JsonProperty(value="isPrivate")
        private Boolean isPrivate;
        @JsonProperty(value="subnetIds")
        private List<String> subnetIds;
        @JsonProperty(value="networkSecurityGroupIds")
        private List<String> networkSecurityGroupIds;
        @JsonProperty(value="listeners")
        private Map<String, Listener> listeners;
        @JsonProperty(value="hostnames")
        private Map<String, Hostname> hostnames;
        @JsonProperty(value="sslCipherSuites")
        private Map<String, SSLCipherSuite> sslCipherSuites;
        @JsonProperty(value="certificates")
        private Map<String, Certificate> certificates;
        @JsonProperty(value="backendSets")
        private Map<String, BackendSet> backendSets;
        @JsonProperty(value="pathRouteSets")
        private Map<String, PathRouteSet> pathRouteSets;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="ruleSets")
        private Map<String, RuleSet> ruleSets;
        @JsonProperty(value="routingPolicies")
        private Map<String, RoutingPolicy> routingPolicies;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder ipAddresses(List<IpAddress> ipAddresses) {
            this.ipAddresses = ipAddresses;
            this.__explicitlySet__.add("ipAddresses");
            return this;
        }

        public Builder shapeName(String shapeName) {
            this.shapeName = shapeName;
            this.__explicitlySet__.add("shapeName");
            return this;
        }

        public Builder shapeDetails(ShapeDetails shapeDetails) {
            this.shapeDetails = shapeDetails;
            this.__explicitlySet__.add("shapeDetails");
            return this;
        }

        public Builder isPrivate(Boolean isPrivate) {
            this.isPrivate = isPrivate;
            this.__explicitlySet__.add("isPrivate");
            return this;
        }

        public Builder subnetIds(List<String> subnetIds) {
            this.subnetIds = subnetIds;
            this.__explicitlySet__.add("subnetIds");
            return this;
        }

        public Builder networkSecurityGroupIds(List<String> networkSecurityGroupIds) {
            this.networkSecurityGroupIds = networkSecurityGroupIds;
            this.__explicitlySet__.add("networkSecurityGroupIds");
            return this;
        }

        public Builder listeners(Map<String, Listener> listeners) {
            this.listeners = listeners;
            this.__explicitlySet__.add("listeners");
            return this;
        }

        public Builder hostnames(Map<String, Hostname> hostnames) {
            this.hostnames = hostnames;
            this.__explicitlySet__.add("hostnames");
            return this;
        }

        public Builder sslCipherSuites(Map<String, SSLCipherSuite> sslCipherSuites) {
            this.sslCipherSuites = sslCipherSuites;
            this.__explicitlySet__.add("sslCipherSuites");
            return this;
        }

        public Builder certificates(Map<String, Certificate> certificates) {
            this.certificates = certificates;
            this.__explicitlySet__.add("certificates");
            return this;
        }

        public Builder backendSets(Map<String, BackendSet> backendSets) {
            this.backendSets = backendSets;
            this.__explicitlySet__.add("backendSets");
            return this;
        }

        public Builder pathRouteSets(Map<String, PathRouteSet> pathRouteSets) {
            this.pathRouteSets = pathRouteSets;
            this.__explicitlySet__.add("pathRouteSets");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder ruleSets(Map<String, RuleSet> ruleSets) {
            this.ruleSets = ruleSets;
            this.__explicitlySet__.add("ruleSets");
            return this;
        }

        public Builder routingPolicies(Map<String, RoutingPolicy> routingPolicies) {
            this.routingPolicies = routingPolicies;
            this.__explicitlySet__.add("routingPolicies");
            return this;
        }

        public LoadBalancer build() {
            LoadBalancer model = new LoadBalancer(this.id, this.compartmentId, this.displayName, this.lifecycleState, this.timeCreated, this.ipAddresses, this.shapeName, this.shapeDetails, this.isPrivate, this.subnetIds, this.networkSecurityGroupIds, this.listeners, this.hostnames, this.sslCipherSuites, this.certificates, this.backendSets, this.pathRouteSets, this.freeformTags, this.definedTags, this.systemTags, this.ruleSets, this.routingPolicies);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LoadBalancer model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("ipAddresses")) {
                this.ipAddresses(model.getIpAddresses());
            }
            if (model.wasPropertyExplicitlySet("shapeName")) {
                this.shapeName(model.getShapeName());
            }
            if (model.wasPropertyExplicitlySet("shapeDetails")) {
                this.shapeDetails(model.getShapeDetails());
            }
            if (model.wasPropertyExplicitlySet("isPrivate")) {
                this.isPrivate(model.getIsPrivate());
            }
            if (model.wasPropertyExplicitlySet("subnetIds")) {
                this.subnetIds(model.getSubnetIds());
            }
            if (model.wasPropertyExplicitlySet("networkSecurityGroupIds")) {
                this.networkSecurityGroupIds(model.getNetworkSecurityGroupIds());
            }
            if (model.wasPropertyExplicitlySet("listeners")) {
                this.listeners(model.getListeners());
            }
            if (model.wasPropertyExplicitlySet("hostnames")) {
                this.hostnames(model.getHostnames());
            }
            if (model.wasPropertyExplicitlySet("sslCipherSuites")) {
                this.sslCipherSuites(model.getSslCipherSuites());
            }
            if (model.wasPropertyExplicitlySet("certificates")) {
                this.certificates(model.getCertificates());
            }
            if (model.wasPropertyExplicitlySet("backendSets")) {
                this.backendSets(model.getBackendSets());
            }
            if (model.wasPropertyExplicitlySet("pathRouteSets")) {
                this.pathRouteSets(model.getPathRouteSets());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("ruleSets")) {
                this.ruleSets(model.getRuleSets());
            }
            if (model.wasPropertyExplicitlySet("routingPolicies")) {
                this.routingPolicies(model.getRoutingPolicies());
            }
            return this;
        }
    }
}

