/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LBCookieSessionPersistenceConfigurationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="cookieName")
    private final String cookieName;
    @JsonProperty(value="disableFallback")
    private final Boolean disableFallback;
    @JsonProperty(value="domain")
    private final String domain;
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="maxAgeInSeconds")
    private final Integer maxAgeInSeconds;
    @JsonProperty(value="isSecure")
    private final Boolean isSecure;
    @JsonProperty(value="isHttpOnly")
    private final Boolean isHttpOnly;

    @Deprecated
    @ConstructorProperties(value={"cookieName", "disableFallback", "domain", "path", "maxAgeInSeconds", "isSecure", "isHttpOnly"})
    public LBCookieSessionPersistenceConfigurationDetails(String cookieName, Boolean disableFallback, String domain, String path, Integer maxAgeInSeconds, Boolean isSecure, Boolean isHttpOnly) {
        this.cookieName = cookieName;
        this.disableFallback = disableFallback;
        this.domain = domain;
        this.path = path;
        this.maxAgeInSeconds = maxAgeInSeconds;
        this.isSecure = isSecure;
        this.isHttpOnly = isHttpOnly;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public Boolean getDisableFallback() {
        return this.disableFallback;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public Integer getMaxAgeInSeconds() {
        return this.maxAgeInSeconds;
    }

    public Boolean getIsSecure() {
        return this.isSecure;
    }

    public Boolean getIsHttpOnly() {
        return this.isHttpOnly;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LBCookieSessionPersistenceConfigurationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("cookieName=").append(String.valueOf(this.cookieName));
        sb.append(", disableFallback=").append(String.valueOf(this.disableFallback));
        sb.append(", domain=").append(String.valueOf(this.domain));
        sb.append(", path=").append(String.valueOf(this.path));
        sb.append(", maxAgeInSeconds=").append(String.valueOf(this.maxAgeInSeconds));
        sb.append(", isSecure=").append(String.valueOf(this.isSecure));
        sb.append(", isHttpOnly=").append(String.valueOf(this.isHttpOnly));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LBCookieSessionPersistenceConfigurationDetails)) {
            return false;
        }
        LBCookieSessionPersistenceConfigurationDetails other = (LBCookieSessionPersistenceConfigurationDetails)((Object)o);
        return Objects.equals(this.cookieName, other.cookieName) && Objects.equals(this.disableFallback, other.disableFallback) && Objects.equals(this.domain, other.domain) && Objects.equals(this.path, other.path) && Objects.equals(this.maxAgeInSeconds, other.maxAgeInSeconds) && Objects.equals(this.isSecure, other.isSecure) && Objects.equals(this.isHttpOnly, other.isHttpOnly) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.cookieName == null ? 43 : this.cookieName.hashCode());
        result = result * 59 + (this.disableFallback == null ? 43 : this.disableFallback.hashCode());
        result = result * 59 + (this.domain == null ? 43 : this.domain.hashCode());
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.maxAgeInSeconds == null ? 43 : this.maxAgeInSeconds.hashCode());
        result = result * 59 + (this.isSecure == null ? 43 : this.isSecure.hashCode());
        result = result * 59 + (this.isHttpOnly == null ? 43 : this.isHttpOnly.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="cookieName")
        private String cookieName;
        @JsonProperty(value="disableFallback")
        private Boolean disableFallback;
        @JsonProperty(value="domain")
        private String domain;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="maxAgeInSeconds")
        private Integer maxAgeInSeconds;
        @JsonProperty(value="isSecure")
        private Boolean isSecure;
        @JsonProperty(value="isHttpOnly")
        private Boolean isHttpOnly;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder cookieName(String cookieName) {
            this.cookieName = cookieName;
            this.__explicitlySet__.add("cookieName");
            return this;
        }

        public Builder disableFallback(Boolean disableFallback) {
            this.disableFallback = disableFallback;
            this.__explicitlySet__.add("disableFallback");
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder maxAgeInSeconds(Integer maxAgeInSeconds) {
            this.maxAgeInSeconds = maxAgeInSeconds;
            this.__explicitlySet__.add("maxAgeInSeconds");
            return this;
        }

        public Builder isSecure(Boolean isSecure) {
            this.isSecure = isSecure;
            this.__explicitlySet__.add("isSecure");
            return this;
        }

        public Builder isHttpOnly(Boolean isHttpOnly) {
            this.isHttpOnly = isHttpOnly;
            this.__explicitlySet__.add("isHttpOnly");
            return this;
        }

        public LBCookieSessionPersistenceConfigurationDetails build() {
            LBCookieSessionPersistenceConfigurationDetails model = new LBCookieSessionPersistenceConfigurationDetails(this.cookieName, this.disableFallback, this.domain, this.path, this.maxAgeInSeconds, this.isSecure, this.isHttpOnly);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LBCookieSessionPersistenceConfigurationDetails model) {
            if (model.wasPropertyExplicitlySet("cookieName")) {
                this.cookieName(model.getCookieName());
            }
            if (model.wasPropertyExplicitlySet("disableFallback")) {
                this.disableFallback(model.getDisableFallback());
            }
            if (model.wasPropertyExplicitlySet("domain")) {
                this.domain(model.getDomain());
            }
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("maxAgeInSeconds")) {
                this.maxAgeInSeconds(model.getMaxAgeInSeconds());
            }
            if (model.wasPropertyExplicitlySet("isSecure")) {
                this.isSecure(model.getIsSecure());
            }
            if (model.wasPropertyExplicitlySet("isHttpOnly")) {
                this.isHttpOnly(model.getIsHttpOnly());
            }
            return this;
        }
    }
}

