/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loadbalancer.model.Rule;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="action")
@JsonFilter(value="explicitlySetFilter")
public final class HttpHeaderRule
extends Rule {
    @JsonProperty(value="areInvalidCharactersAllowed")
    private final Boolean areInvalidCharactersAllowed;
    @JsonProperty(value="httpLargeHeaderSizeInKB")
    private final Integer httpLargeHeaderSizeInKB;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HttpHeaderRule(Boolean areInvalidCharactersAllowed, Integer httpLargeHeaderSizeInKB) {
        this.areInvalidCharactersAllowed = areInvalidCharactersAllowed;
        this.httpLargeHeaderSizeInKB = httpLargeHeaderSizeInKB;
    }

    public Boolean getAreInvalidCharactersAllowed() {
        return this.areInvalidCharactersAllowed;
    }

    public Integer getHttpLargeHeaderSizeInKB() {
        return this.httpLargeHeaderSizeInKB;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpHeaderRule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", areInvalidCharactersAllowed=").append(String.valueOf(this.areInvalidCharactersAllowed));
        sb.append(", httpLargeHeaderSizeInKB=").append(String.valueOf(this.httpLargeHeaderSizeInKB));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpHeaderRule)) {
            return false;
        }
        HttpHeaderRule other = (HttpHeaderRule)((Object)o);
        return Objects.equals(this.areInvalidCharactersAllowed, other.areInvalidCharactersAllowed) && Objects.equals(this.httpLargeHeaderSizeInKB, other.httpLargeHeaderSizeInKB) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.areInvalidCharactersAllowed == null ? 43 : this.areInvalidCharactersAllowed.hashCode());
        result = result * 59 + (this.httpLargeHeaderSizeInKB == null ? 43 : this.httpLargeHeaderSizeInKB.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="areInvalidCharactersAllowed")
        private Boolean areInvalidCharactersAllowed;
        @JsonProperty(value="httpLargeHeaderSizeInKB")
        private Integer httpLargeHeaderSizeInKB;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder areInvalidCharactersAllowed(Boolean areInvalidCharactersAllowed) {
            this.areInvalidCharactersAllowed = areInvalidCharactersAllowed;
            this.__explicitlySet__.add("areInvalidCharactersAllowed");
            return this;
        }

        public Builder httpLargeHeaderSizeInKB(Integer httpLargeHeaderSizeInKB) {
            this.httpLargeHeaderSizeInKB = httpLargeHeaderSizeInKB;
            this.__explicitlySet__.add("httpLargeHeaderSizeInKB");
            return this;
        }

        public HttpHeaderRule build() {
            HttpHeaderRule model = new HttpHeaderRule(this.areInvalidCharactersAllowed, this.httpLargeHeaderSizeInKB);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HttpHeaderRule model) {
            if (model.wasPropertyExplicitlySet("areInvalidCharactersAllowed")) {
                this.areInvalidCharactersAllowed(model.getAreInvalidCharactersAllowed());
            }
            if (model.wasPropertyExplicitlySet("httpLargeHeaderSizeInKB")) {
                this.httpLargeHeaderSizeInKB(model.getHttpLargeHeaderSizeInKB());
            }
            return this;
        }
    }
}

