/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ConnectionConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="idleTimeout")
    private final Long idleTimeout;
    @JsonProperty(value="backendTcpProxyProtocolVersion")
    private final Integer backendTcpProxyProtocolVersion;

    @Deprecated
    @ConstructorProperties(value={"idleTimeout", "backendTcpProxyProtocolVersion"})
    public ConnectionConfiguration(Long idleTimeout, Integer backendTcpProxyProtocolVersion) {
        this.idleTimeout = idleTimeout;
        this.backendTcpProxyProtocolVersion = backendTcpProxyProtocolVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getIdleTimeout() {
        return this.idleTimeout;
    }

    public Integer getBackendTcpProxyProtocolVersion() {
        return this.backendTcpProxyProtocolVersion;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("idleTimeout=").append(String.valueOf(this.idleTimeout));
        sb.append(", backendTcpProxyProtocolVersion=").append(String.valueOf(this.backendTcpProxyProtocolVersion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionConfiguration)) {
            return false;
        }
        ConnectionConfiguration other = (ConnectionConfiguration)((Object)o);
        return Objects.equals(this.idleTimeout, other.idleTimeout) && Objects.equals(this.backendTcpProxyProtocolVersion, other.backendTcpProxyProtocolVersion) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.idleTimeout == null ? 43 : this.idleTimeout.hashCode());
        result = result * 59 + (this.backendTcpProxyProtocolVersion == null ? 43 : this.backendTcpProxyProtocolVersion.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="idleTimeout")
        private Long idleTimeout;
        @JsonProperty(value="backendTcpProxyProtocolVersion")
        private Integer backendTcpProxyProtocolVersion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder idleTimeout(Long idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.__explicitlySet__.add("idleTimeout");
            return this;
        }

        public Builder backendTcpProxyProtocolVersion(Integer backendTcpProxyProtocolVersion) {
            this.backendTcpProxyProtocolVersion = backendTcpProxyProtocolVersion;
            this.__explicitlySet__.add("backendTcpProxyProtocolVersion");
            return this;
        }

        public ConnectionConfiguration build() {
            ConnectionConfiguration model = new ConnectionConfiguration(this.idleTimeout, this.backendTcpProxyProtocolVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConnectionConfiguration model) {
            if (model.wasPropertyExplicitlySet("idleTimeout")) {
                this.idleTimeout(model.getIdleTimeout());
            }
            if (model.wasPropertyExplicitlySet("backendTcpProxyProtocolVersion")) {
                this.backendTcpProxyProtocolVersion(model.getBackendTcpProxyProtocolVersion());
            }
            return this;
        }
    }
}

