/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.limits.model.RemoveLockDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RemoveQuotaLockRequest
extends BmcRequest<RemoveLockDetails> {
    private String quotaId;
    private RemoveLockDetails removeLockDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getQuotaId() {
        return this.quotaId;
    }

    public RemoveLockDetails getRemoveLockDetails() {
        return this.removeLockDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public RemoveLockDetails getBody$() {
        return this.removeLockDetails;
    }

    public Builder toBuilder() {
        return new Builder().quotaId(this.quotaId).removeLockDetails(this.removeLockDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",quotaId=").append(String.valueOf(this.quotaId));
        sb.append(",removeLockDetails=").append(String.valueOf((Object)this.removeLockDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoveQuotaLockRequest)) {
            return false;
        }
        RemoveQuotaLockRequest other = (RemoveQuotaLockRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.quotaId, other.quotaId) && Objects.equals((Object)this.removeLockDetails, (Object)other.removeLockDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.quotaId == null ? 43 : this.quotaId.hashCode());
        result = result * 59 + (this.removeLockDetails == null ? 43 : this.removeLockDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RemoveQuotaLockRequest, RemoveLockDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String quotaId = null;
        private RemoveLockDetails removeLockDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder quotaId(String quotaId) {
            this.quotaId = quotaId;
            return this;
        }

        public Builder removeLockDetails(RemoveLockDetails removeLockDetails) {
            this.removeLockDetails = removeLockDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RemoveQuotaLockRequest o) {
            this.quotaId(o.getQuotaId());
            this.removeLockDetails(o.getRemoveLockDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RemoveQuotaLockRequest build() {
            RemoveQuotaLockRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RemoveLockDetails body) {
            this.removeLockDetails(body);
            return this;
        }

        public RemoveQuotaLockRequest buildWithoutInvocationCallback() {
            RemoveQuotaLockRequest request = new RemoveQuotaLockRequest();
            request.quotaId = this.quotaId;
            request.removeLockDetails = this.removeLockDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

