/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetResourceAvailabilityRequest
extends BmcRequest<Void> {
    private String serviceName;
    private String limitName;
    private String compartmentId;
    private String availabilityDomain;
    private String opcRequestId;

    public String getServiceName() {
        return this.serviceName;
    }

    public String getLimitName() {
        return this.limitName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().serviceName(this.serviceName).limitName(this.limitName).compartmentId(this.compartmentId).availabilityDomain(this.availabilityDomain).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",serviceName=").append(String.valueOf(this.serviceName));
        sb.append(",limitName=").append(String.valueOf(this.limitName));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetResourceAvailabilityRequest)) {
            return false;
        }
        GetResourceAvailabilityRequest other = (GetResourceAvailabilityRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.limitName, other.limitName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.serviceName == null ? 43 : this.serviceName.hashCode());
        result = result * 59 + (this.limitName == null ? 43 : this.limitName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetResourceAvailabilityRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String serviceName = null;
        private String limitName = null;
        private String compartmentId = null;
        private String availabilityDomain = null;
        private String opcRequestId = null;

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder limitName(String limitName) {
            this.limitName = limitName;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetResourceAvailabilityRequest o) {
            this.serviceName(o.getServiceName());
            this.limitName(o.getLimitName());
            this.compartmentId(o.getCompartmentId());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetResourceAvailabilityRequest build() {
            GetResourceAvailabilityRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetResourceAvailabilityRequest buildWithoutInvocationCallback() {
            GetResourceAvailabilityRequest request = new GetResourceAvailabilityRequest();
            request.serviceName = this.serviceName;
            request.limitName = this.limitName;
            request.compartmentId = this.compartmentId;
            request.availabilityDomain = this.availabilityDomain;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

