/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits;

import com.oracle.bmc.limits.Quotas;
import com.oracle.bmc.limits.model.QuotaSummary;
import com.oracle.bmc.limits.requests.ListQuotasRequest;
import com.oracle.bmc.limits.responses.ListQuotasResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class QuotasPaginators {
    private final Quotas client;

    public QuotasPaginators(Quotas client) {
        this.client = client;
    }

    public Iterable<ListQuotasResponse> listQuotasResponseIterator(final ListQuotasRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListQuotasRequest.Builder>(){

            @Override
            public ListQuotasRequest.Builder get() {
                return ListQuotasRequest.builder().copy(request);
            }
        }, (Function)new Function<ListQuotasResponse, String>(){

            @Override
            public String apply(ListQuotasResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListQuotasRequest.Builder>, ListQuotasRequest>(){

            @Override
            public ListQuotasRequest apply(RequestBuilderAndToken<ListQuotasRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListQuotasRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListQuotasRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListQuotasRequest, ListQuotasResponse>(){

            @Override
            public ListQuotasResponse apply(ListQuotasRequest request) {
                return QuotasPaginators.this.client.listQuotas(request);
            }
        });
    }

    public Iterable<QuotaSummary> listQuotasRecordIterator(final ListQuotasRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListQuotasRequest.Builder>(){

            @Override
            public ListQuotasRequest.Builder get() {
                return ListQuotasRequest.builder().copy(request);
            }
        }, (Function)new Function<ListQuotasResponse, String>(){

            @Override
            public String apply(ListQuotasResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListQuotasRequest.Builder>, ListQuotasRequest>(){

            @Override
            public ListQuotasRequest apply(RequestBuilderAndToken<ListQuotasRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListQuotasRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListQuotasRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListQuotasRequest, ListQuotasResponse>(){

            @Override
            public ListQuotasResponse apply(ListQuotasRequest request) {
                return QuotasPaginators.this.client.listQuotas(request);
            }
        }, (Function)new Function<ListQuotasResponse, List<QuotaSummary>>(){

            @Override
            public List<QuotaSummary> apply(ListQuotasResponse response) {
                return response.getItems();
            }
        });
    }
}

