/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.licensemanager.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.licensemanager.model.BulkUploadFailedRecordInfo;
import com.oracle.bmc.licensemanager.model.BulkUploadValidationErrorInfo;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BulkUploadResponse
extends ExplicitlySetBmcModel {
    @JsonProperty(value="totalSupportedRecords")
    private final Integer totalSupportedRecords;
    @JsonProperty(value="totalSupportedRecordsSaved")
    private final Integer totalSupportedRecordsSaved;
    @JsonProperty(value="totalSupportedDuplicateRecords")
    private final Integer totalSupportedDuplicateRecords;
    @JsonProperty(value="totalSupportedFailedLicenseRecords")
    private final Integer totalSupportedFailedLicenseRecords;
    @JsonProperty(value="totalSupportedInvalidRecords")
    private final Integer totalSupportedInvalidRecords;
    @JsonProperty(value="validationErrorInfo")
    private final List<BulkUploadValidationErrorInfo> validationErrorInfo;
    @JsonProperty(value="failedLicenseRecordInfo")
    private final List<BulkUploadFailedRecordInfo> failedLicenseRecordInfo;
    @JsonProperty(value="message")
    private final String message;

    @Deprecated
    @ConstructorProperties(value={"totalSupportedRecords", "totalSupportedRecordsSaved", "totalSupportedDuplicateRecords", "totalSupportedFailedLicenseRecords", "totalSupportedInvalidRecords", "validationErrorInfo", "failedLicenseRecordInfo", "message"})
    public BulkUploadResponse(Integer totalSupportedRecords, Integer totalSupportedRecordsSaved, Integer totalSupportedDuplicateRecords, Integer totalSupportedFailedLicenseRecords, Integer totalSupportedInvalidRecords, List<BulkUploadValidationErrorInfo> validationErrorInfo, List<BulkUploadFailedRecordInfo> failedLicenseRecordInfo, String message) {
        this.totalSupportedRecords = totalSupportedRecords;
        this.totalSupportedRecordsSaved = totalSupportedRecordsSaved;
        this.totalSupportedDuplicateRecords = totalSupportedDuplicateRecords;
        this.totalSupportedFailedLicenseRecords = totalSupportedFailedLicenseRecords;
        this.totalSupportedInvalidRecords = totalSupportedInvalidRecords;
        this.validationErrorInfo = validationErrorInfo;
        this.failedLicenseRecordInfo = failedLicenseRecordInfo;
        this.message = message;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getTotalSupportedRecords() {
        return this.totalSupportedRecords;
    }

    public Integer getTotalSupportedRecordsSaved() {
        return this.totalSupportedRecordsSaved;
    }

    public Integer getTotalSupportedDuplicateRecords() {
        return this.totalSupportedDuplicateRecords;
    }

    public Integer getTotalSupportedFailedLicenseRecords() {
        return this.totalSupportedFailedLicenseRecords;
    }

    public Integer getTotalSupportedInvalidRecords() {
        return this.totalSupportedInvalidRecords;
    }

    public List<BulkUploadValidationErrorInfo> getValidationErrorInfo() {
        return this.validationErrorInfo;
    }

    public List<BulkUploadFailedRecordInfo> getFailedLicenseRecordInfo() {
        return this.failedLicenseRecordInfo;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BulkUploadResponse(");
        sb.append("super=").append(super.toString());
        sb.append("totalSupportedRecords=").append(String.valueOf(this.totalSupportedRecords));
        sb.append(", totalSupportedRecordsSaved=").append(String.valueOf(this.totalSupportedRecordsSaved));
        sb.append(", totalSupportedDuplicateRecords=").append(String.valueOf(this.totalSupportedDuplicateRecords));
        sb.append(", totalSupportedFailedLicenseRecords=").append(String.valueOf(this.totalSupportedFailedLicenseRecords));
        sb.append(", totalSupportedInvalidRecords=").append(String.valueOf(this.totalSupportedInvalidRecords));
        sb.append(", validationErrorInfo=").append(String.valueOf(this.validationErrorInfo));
        sb.append(", failedLicenseRecordInfo=").append(String.valueOf(this.failedLicenseRecordInfo));
        sb.append(", message=").append(String.valueOf(this.message));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkUploadResponse)) {
            return false;
        }
        BulkUploadResponse other = (BulkUploadResponse)((Object)o);
        return Objects.equals(this.totalSupportedRecords, other.totalSupportedRecords) && Objects.equals(this.totalSupportedRecordsSaved, other.totalSupportedRecordsSaved) && Objects.equals(this.totalSupportedDuplicateRecords, other.totalSupportedDuplicateRecords) && Objects.equals(this.totalSupportedFailedLicenseRecords, other.totalSupportedFailedLicenseRecords) && Objects.equals(this.totalSupportedInvalidRecords, other.totalSupportedInvalidRecords) && Objects.equals(this.validationErrorInfo, other.validationErrorInfo) && Objects.equals(this.failedLicenseRecordInfo, other.failedLicenseRecordInfo) && Objects.equals(this.message, other.message) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.totalSupportedRecords == null ? 43 : this.totalSupportedRecords.hashCode());
        result = result * 59 + (this.totalSupportedRecordsSaved == null ? 43 : this.totalSupportedRecordsSaved.hashCode());
        result = result * 59 + (this.totalSupportedDuplicateRecords == null ? 43 : this.totalSupportedDuplicateRecords.hashCode());
        result = result * 59 + (this.totalSupportedFailedLicenseRecords == null ? 43 : this.totalSupportedFailedLicenseRecords.hashCode());
        result = result * 59 + (this.totalSupportedInvalidRecords == null ? 43 : this.totalSupportedInvalidRecords.hashCode());
        result = result * 59 + (this.validationErrorInfo == null ? 43 : this.validationErrorInfo.hashCode());
        result = result * 59 + (this.failedLicenseRecordInfo == null ? 43 : this.failedLicenseRecordInfo.hashCode());
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="totalSupportedRecords")
        private Integer totalSupportedRecords;
        @JsonProperty(value="totalSupportedRecordsSaved")
        private Integer totalSupportedRecordsSaved;
        @JsonProperty(value="totalSupportedDuplicateRecords")
        private Integer totalSupportedDuplicateRecords;
        @JsonProperty(value="totalSupportedFailedLicenseRecords")
        private Integer totalSupportedFailedLicenseRecords;
        @JsonProperty(value="totalSupportedInvalidRecords")
        private Integer totalSupportedInvalidRecords;
        @JsonProperty(value="validationErrorInfo")
        private List<BulkUploadValidationErrorInfo> validationErrorInfo;
        @JsonProperty(value="failedLicenseRecordInfo")
        private List<BulkUploadFailedRecordInfo> failedLicenseRecordInfo;
        @JsonProperty(value="message")
        private String message;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder totalSupportedRecords(Integer totalSupportedRecords) {
            this.totalSupportedRecords = totalSupportedRecords;
            this.__explicitlySet__.add("totalSupportedRecords");
            return this;
        }

        public Builder totalSupportedRecordsSaved(Integer totalSupportedRecordsSaved) {
            this.totalSupportedRecordsSaved = totalSupportedRecordsSaved;
            this.__explicitlySet__.add("totalSupportedRecordsSaved");
            return this;
        }

        public Builder totalSupportedDuplicateRecords(Integer totalSupportedDuplicateRecords) {
            this.totalSupportedDuplicateRecords = totalSupportedDuplicateRecords;
            this.__explicitlySet__.add("totalSupportedDuplicateRecords");
            return this;
        }

        public Builder totalSupportedFailedLicenseRecords(Integer totalSupportedFailedLicenseRecords) {
            this.totalSupportedFailedLicenseRecords = totalSupportedFailedLicenseRecords;
            this.__explicitlySet__.add("totalSupportedFailedLicenseRecords");
            return this;
        }

        public Builder totalSupportedInvalidRecords(Integer totalSupportedInvalidRecords) {
            this.totalSupportedInvalidRecords = totalSupportedInvalidRecords;
            this.__explicitlySet__.add("totalSupportedInvalidRecords");
            return this;
        }

        public Builder validationErrorInfo(List<BulkUploadValidationErrorInfo> validationErrorInfo) {
            this.validationErrorInfo = validationErrorInfo;
            this.__explicitlySet__.add("validationErrorInfo");
            return this;
        }

        public Builder failedLicenseRecordInfo(List<BulkUploadFailedRecordInfo> failedLicenseRecordInfo) {
            this.failedLicenseRecordInfo = failedLicenseRecordInfo;
            this.__explicitlySet__.add("failedLicenseRecordInfo");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public BulkUploadResponse build() {
            BulkUploadResponse model = new BulkUploadResponse(this.totalSupportedRecords, this.totalSupportedRecordsSaved, this.totalSupportedDuplicateRecords, this.totalSupportedFailedLicenseRecords, this.totalSupportedInvalidRecords, this.validationErrorInfo, this.failedLicenseRecordInfo, this.message);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BulkUploadResponse model) {
            if (model.wasPropertyExplicitlySet("totalSupportedRecords")) {
                this.totalSupportedRecords(model.getTotalSupportedRecords());
            }
            if (model.wasPropertyExplicitlySet("totalSupportedRecordsSaved")) {
                this.totalSupportedRecordsSaved(model.getTotalSupportedRecordsSaved());
            }
            if (model.wasPropertyExplicitlySet("totalSupportedDuplicateRecords")) {
                this.totalSupportedDuplicateRecords(model.getTotalSupportedDuplicateRecords());
            }
            if (model.wasPropertyExplicitlySet("totalSupportedFailedLicenseRecords")) {
                this.totalSupportedFailedLicenseRecords(model.getTotalSupportedFailedLicenseRecords());
            }
            if (model.wasPropertyExplicitlySet("totalSupportedInvalidRecords")) {
                this.totalSupportedInvalidRecords(model.getTotalSupportedInvalidRecords());
            }
            if (model.wasPropertyExplicitlySet("validationErrorInfo")) {
                this.validationErrorInfo(model.getValidationErrorInfo());
            }
            if (model.wasPropertyExplicitlySet("failedLicenseRecordInfo")) {
                this.failedLicenseRecordInfo(model.getFailedLicenseRecordInfo());
            }
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            return this;
        }
    }
}

