/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jms.model.ApplicationSortBy;
import com.oracle.bmc.jms.model.OsFamily;
import com.oracle.bmc.jms.model.SortOrder;
import com.oracle.bmc.jms.model.SummarizeApplicationUsageFields;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class SummarizeApplicationUsageRequest
extends BmcRequest<Void> {
    private String fleetId;
    private String applicationId;
    private String displayName;
    private String applicationType;
    private String jreVendor;
    private String jreDistribution;
    private String jreVersion;
    private String installationPath;
    private String managedInstanceId;
    private List<SummarizeApplicationUsageFields> fields;
    private Date timeStart;
    private Date timeEnd;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private ApplicationSortBy sortBy;
    private String opcRequestId;
    private List<OsFamily> osFamily;
    private String displayNameContains;
    private String libraryKey;

    public String getFleetId() {
        return this.fleetId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public String getJreVendor() {
        return this.jreVendor;
    }

    public String getJreDistribution() {
        return this.jreDistribution;
    }

    public String getJreVersion() {
        return this.jreVersion;
    }

    public String getInstallationPath() {
        return this.installationPath;
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public List<SummarizeApplicationUsageFields> getFields() {
        return this.fields;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public ApplicationSortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<OsFamily> getOsFamily() {
        return this.osFamily;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public String getLibraryKey() {
        return this.libraryKey;
    }

    public Builder toBuilder() {
        return new Builder().fleetId(this.fleetId).applicationId(this.applicationId).displayName(this.displayName).applicationType(this.applicationType).jreVendor(this.jreVendor).jreDistribution(this.jreDistribution).jreVersion(this.jreVersion).installationPath(this.installationPath).managedInstanceId(this.managedInstanceId).fields(this.fields).timeStart(this.timeStart).timeEnd(this.timeEnd).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId).osFamily(this.osFamily).displayNameContains(this.displayNameContains).libraryKey(this.libraryKey);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",applicationId=").append(String.valueOf(this.applicationId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",applicationType=").append(String.valueOf(this.applicationType));
        sb.append(",jreVendor=").append(String.valueOf(this.jreVendor));
        sb.append(",jreDistribution=").append(String.valueOf(this.jreDistribution));
        sb.append(",jreVersion=").append(String.valueOf(this.jreVersion));
        sb.append(",installationPath=").append(String.valueOf(this.installationPath));
        sb.append(",managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",timeStart=").append(String.valueOf(this.timeStart));
        sb.append(",timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",osFamily=").append(String.valueOf(this.osFamily));
        sb.append(",displayNameContains=").append(String.valueOf(this.displayNameContains));
        sb.append(",libraryKey=").append(String.valueOf(this.libraryKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeApplicationUsageRequest)) {
            return false;
        }
        SummarizeApplicationUsageRequest other = (SummarizeApplicationUsageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals(this.applicationId, other.applicationId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.applicationType, other.applicationType) && Objects.equals(this.jreVendor, other.jreVendor) && Objects.equals(this.jreDistribution, other.jreDistribution) && Objects.equals(this.jreVersion, other.jreVersion) && Objects.equals(this.installationPath, other.installationPath) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.fields, other.fields) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.osFamily, other.osFamily) && Objects.equals(this.displayNameContains, other.displayNameContains) && Objects.equals(this.libraryKey, other.libraryKey);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.applicationId == null ? 43 : this.applicationId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.applicationType == null ? 43 : this.applicationType.hashCode());
        result = result * 59 + (this.jreVendor == null ? 43 : this.jreVendor.hashCode());
        result = result * 59 + (this.jreDistribution == null ? 43 : this.jreDistribution.hashCode());
        result = result * 59 + (this.jreVersion == null ? 43 : this.jreVersion.hashCode());
        result = result * 59 + (this.installationPath == null ? 43 : this.installationPath.hashCode());
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.displayNameContains == null ? 43 : this.displayNameContains.hashCode());
        result = result * 59 + (this.libraryKey == null ? 43 : this.libraryKey.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeApplicationUsageRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetId = null;
        private String applicationId = null;
        private String displayName = null;
        private String applicationType = null;
        private String jreVendor = null;
        private String jreDistribution = null;
        private String jreVersion = null;
        private String installationPath = null;
        private String managedInstanceId = null;
        private List<SummarizeApplicationUsageFields> fields = null;
        private Date timeStart = null;
        private Date timeEnd = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private ApplicationSortBy sortBy = null;
        private String opcRequestId = null;
        private List<OsFamily> osFamily = null;
        private String displayNameContains = null;
        private String libraryKey = null;

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder applicationType(String applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        public Builder jreVendor(String jreVendor) {
            this.jreVendor = jreVendor;
            return this;
        }

        public Builder jreDistribution(String jreDistribution) {
            this.jreDistribution = jreDistribution;
            return this;
        }

        public Builder jreVersion(String jreVersion) {
            this.jreVersion = jreVersion;
            return this;
        }

        public Builder installationPath(String installationPath) {
            this.installationPath = installationPath;
            return this;
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder fields(List<SummarizeApplicationUsageFields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(SummarizeApplicationUsageFields singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(ApplicationSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder osFamily(List<OsFamily> osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        public Builder osFamily(OsFamily singularValue) {
            return this.osFamily(Arrays.asList(singularValue));
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder libraryKey(String libraryKey) {
            this.libraryKey = libraryKey;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeApplicationUsageRequest o) {
            this.fleetId(o.getFleetId());
            this.applicationId(o.getApplicationId());
            this.displayName(o.getDisplayName());
            this.applicationType(o.getApplicationType());
            this.jreVendor(o.getJreVendor());
            this.jreDistribution(o.getJreDistribution());
            this.jreVersion(o.getJreVersion());
            this.installationPath(o.getInstallationPath());
            this.managedInstanceId(o.getManagedInstanceId());
            this.fields(o.getFields());
            this.timeStart(o.getTimeStart());
            this.timeEnd(o.getTimeEnd());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.osFamily(o.getOsFamily());
            this.displayNameContains(o.getDisplayNameContains());
            this.libraryKey(o.getLibraryKey());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeApplicationUsageRequest build() {
            SummarizeApplicationUsageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeApplicationUsageRequest buildWithoutInvocationCallback() {
            SummarizeApplicationUsageRequest request = new SummarizeApplicationUsageRequest();
            request.fleetId = this.fleetId;
            request.applicationId = this.applicationId;
            request.displayName = this.displayName;
            request.applicationType = this.applicationType;
            request.jreVendor = this.jreVendor;
            request.jreDistribution = this.jreDistribution;
            request.jreVersion = this.jreVersion;
            request.installationPath = this.installationPath;
            request.managedInstanceId = this.managedInstanceId;
            request.fields = this.fields;
            request.timeStart = this.timeStart;
            request.timeEnd = this.timeEnd;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            request.osFamily = this.osFamily;
            request.displayNameContains = this.displayNameContains;
            request.libraryKey = this.libraryKey;
            return request;
        }
    }
}

