/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jms.model.RequestCryptoAnalysesDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RequestCryptoAnalysesRequest
extends BmcRequest<RequestCryptoAnalysesDetails> {
    private String fleetId;
    private RequestCryptoAnalysesDetails requestCryptoAnalysesDetails;
    private String opcRequestId;

    public String getFleetId() {
        return this.fleetId;
    }

    public RequestCryptoAnalysesDetails getRequestCryptoAnalysesDetails() {
        return this.requestCryptoAnalysesDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public RequestCryptoAnalysesDetails getBody$() {
        return this.requestCryptoAnalysesDetails;
    }

    public Builder toBuilder() {
        return new Builder().fleetId(this.fleetId).requestCryptoAnalysesDetails(this.requestCryptoAnalysesDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",requestCryptoAnalysesDetails=").append(String.valueOf((Object)this.requestCryptoAnalysesDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestCryptoAnalysesRequest)) {
            return false;
        }
        RequestCryptoAnalysesRequest other = (RequestCryptoAnalysesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals((Object)this.requestCryptoAnalysesDetails, (Object)other.requestCryptoAnalysesDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.requestCryptoAnalysesDetails == null ? 43 : this.requestCryptoAnalysesDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RequestCryptoAnalysesRequest, RequestCryptoAnalysesDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetId = null;
        private RequestCryptoAnalysesDetails requestCryptoAnalysesDetails = null;
        private String opcRequestId = null;

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder requestCryptoAnalysesDetails(RequestCryptoAnalysesDetails requestCryptoAnalysesDetails) {
            this.requestCryptoAnalysesDetails = requestCryptoAnalysesDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RequestCryptoAnalysesRequest o) {
            this.fleetId(o.getFleetId());
            this.requestCryptoAnalysesDetails(o.getRequestCryptoAnalysesDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RequestCryptoAnalysesRequest build() {
            RequestCryptoAnalysesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RequestCryptoAnalysesDetails body) {
            this.requestCryptoAnalysesDetails(body);
            return this;
        }

        public RequestCryptoAnalysesRequest buildWithoutInvocationCallback() {
            RequestCryptoAnalysesRequest request = new RequestCryptoAnalysesRequest();
            request.fleetId = this.fleetId;
            request.requestCryptoAnalysesDetails = this.requestCryptoAnalysesDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

