/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jms.model.GenerateAgentDeployScriptDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GenerateAgentDeployScriptRequest
extends BmcRequest<GenerateAgentDeployScriptDetails> {
    private String fleetId;
    private GenerateAgentDeployScriptDetails generateAgentDeployScriptDetails;
    private String opcRequestId;

    public String getFleetId() {
        return this.fleetId;
    }

    public GenerateAgentDeployScriptDetails getGenerateAgentDeployScriptDetails() {
        return this.generateAgentDeployScriptDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public GenerateAgentDeployScriptDetails getBody$() {
        return this.generateAgentDeployScriptDetails;
    }

    public Builder toBuilder() {
        return new Builder().fleetId(this.fleetId).generateAgentDeployScriptDetails(this.generateAgentDeployScriptDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",generateAgentDeployScriptDetails=").append(String.valueOf((Object)this.generateAgentDeployScriptDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerateAgentDeployScriptRequest)) {
            return false;
        }
        GenerateAgentDeployScriptRequest other = (GenerateAgentDeployScriptRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals((Object)this.generateAgentDeployScriptDetails, (Object)other.generateAgentDeployScriptDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.generateAgentDeployScriptDetails == null ? 43 : this.generateAgentDeployScriptDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GenerateAgentDeployScriptRequest, GenerateAgentDeployScriptDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetId = null;
        private GenerateAgentDeployScriptDetails generateAgentDeployScriptDetails = null;
        private String opcRequestId = null;

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder generateAgentDeployScriptDetails(GenerateAgentDeployScriptDetails generateAgentDeployScriptDetails) {
            this.generateAgentDeployScriptDetails = generateAgentDeployScriptDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GenerateAgentDeployScriptRequest o) {
            this.fleetId(o.getFleetId());
            this.generateAgentDeployScriptDetails(o.getGenerateAgentDeployScriptDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GenerateAgentDeployScriptRequest build() {
            GenerateAgentDeployScriptRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(GenerateAgentDeployScriptDetails body) {
            this.generateAgentDeployScriptDetails(body);
            return this;
        }

        public GenerateAgentDeployScriptRequest buildWithoutInvocationCallback() {
            GenerateAgentDeployScriptRequest request = new GenerateAgentDeployScriptRequest();
            request.fleetId = this.fleetId;
            request.generateAgentDeployScriptDetails = this.generateAgentDeployScriptDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

