/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResourceInventory
extends ExplicitlySetBmcModel {
    @JsonProperty(value="activeFleetCount")
    private final Integer activeFleetCount;
    @JsonProperty(value="managedInstanceCount")
    private final Integer managedInstanceCount;
    @JsonProperty(value="jreCount")
    private final Integer jreCount;
    @JsonProperty(value="installationCount")
    private final Integer installationCount;
    @JsonProperty(value="applicationCount")
    private final Integer applicationCount;

    @Deprecated
    @ConstructorProperties(value={"activeFleetCount", "managedInstanceCount", "jreCount", "installationCount", "applicationCount"})
    public ResourceInventory(Integer activeFleetCount, Integer managedInstanceCount, Integer jreCount, Integer installationCount, Integer applicationCount) {
        this.activeFleetCount = activeFleetCount;
        this.managedInstanceCount = managedInstanceCount;
        this.jreCount = jreCount;
        this.installationCount = installationCount;
        this.applicationCount = applicationCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getActiveFleetCount() {
        return this.activeFleetCount;
    }

    public Integer getManagedInstanceCount() {
        return this.managedInstanceCount;
    }

    public Integer getJreCount() {
        return this.jreCount;
    }

    public Integer getInstallationCount() {
        return this.installationCount;
    }

    public Integer getApplicationCount() {
        return this.applicationCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceInventory(");
        sb.append("super=").append(super.toString());
        sb.append("activeFleetCount=").append(String.valueOf(this.activeFleetCount));
        sb.append(", managedInstanceCount=").append(String.valueOf(this.managedInstanceCount));
        sb.append(", jreCount=").append(String.valueOf(this.jreCount));
        sb.append(", installationCount=").append(String.valueOf(this.installationCount));
        sb.append(", applicationCount=").append(String.valueOf(this.applicationCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceInventory)) {
            return false;
        }
        ResourceInventory other = (ResourceInventory)((Object)o);
        return Objects.equals(this.activeFleetCount, other.activeFleetCount) && Objects.equals(this.managedInstanceCount, other.managedInstanceCount) && Objects.equals(this.jreCount, other.jreCount) && Objects.equals(this.installationCount, other.installationCount) && Objects.equals(this.applicationCount, other.applicationCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.activeFleetCount == null ? 43 : this.activeFleetCount.hashCode());
        result = result * 59 + (this.managedInstanceCount == null ? 43 : this.managedInstanceCount.hashCode());
        result = result * 59 + (this.jreCount == null ? 43 : this.jreCount.hashCode());
        result = result * 59 + (this.installationCount == null ? 43 : this.installationCount.hashCode());
        result = result * 59 + (this.applicationCount == null ? 43 : this.applicationCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="activeFleetCount")
        private Integer activeFleetCount;
        @JsonProperty(value="managedInstanceCount")
        private Integer managedInstanceCount;
        @JsonProperty(value="jreCount")
        private Integer jreCount;
        @JsonProperty(value="installationCount")
        private Integer installationCount;
        @JsonProperty(value="applicationCount")
        private Integer applicationCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder activeFleetCount(Integer activeFleetCount) {
            this.activeFleetCount = activeFleetCount;
            this.__explicitlySet__.add("activeFleetCount");
            return this;
        }

        public Builder managedInstanceCount(Integer managedInstanceCount) {
            this.managedInstanceCount = managedInstanceCount;
            this.__explicitlySet__.add("managedInstanceCount");
            return this;
        }

        public Builder jreCount(Integer jreCount) {
            this.jreCount = jreCount;
            this.__explicitlySet__.add("jreCount");
            return this;
        }

        public Builder installationCount(Integer installationCount) {
            this.installationCount = installationCount;
            this.__explicitlySet__.add("installationCount");
            return this;
        }

        public Builder applicationCount(Integer applicationCount) {
            this.applicationCount = applicationCount;
            this.__explicitlySet__.add("applicationCount");
            return this;
        }

        public ResourceInventory build() {
            ResourceInventory model = new ResourceInventory(this.activeFleetCount, this.managedInstanceCount, this.jreCount, this.installationCount, this.applicationCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourceInventory model) {
            if (model.wasPropertyExplicitlySet("activeFleetCount")) {
                this.activeFleetCount(model.getActiveFleetCount());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceCount")) {
                this.managedInstanceCount(model.getManagedInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("jreCount")) {
                this.jreCount(model.getJreCount());
            }
            if (model.wasPropertyExplicitlySet("installationCount")) {
                this.installationCount(model.getInstallationCount());
            }
            if (model.wasPropertyExplicitlySet("applicationCount")) {
                this.applicationCount(model.getApplicationCount());
            }
            return this;
        }
    }
}

