/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LibraryUsage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="libraryKey")
    private final String libraryKey;
    @JsonProperty(value="fleetId")
    private final String fleetId;
    @JsonProperty(value="libraryName")
    private final String libraryName;
    @JsonProperty(value="libraryVersion")
    private final String libraryVersion;
    @JsonProperty(value="cvssScore")
    private final Float cvssScore;
    @JsonProperty(value="approximateApplicationCount")
    private final Integer approximateApplicationCount;
    @JsonProperty(value="approximateJavaServerInstanceCount")
    private final Integer approximateJavaServerInstanceCount;
    @JsonProperty(value="approximateDeployedApplicationCount")
    private final Integer approximateDeployedApplicationCount;
    @JsonProperty(value="approximateManagedInstanceCount")
    private final Integer approximateManagedInstanceCount;
    @JsonProperty(value="timeStart")
    private final Date timeStart;
    @JsonProperty(value="timeEnd")
    private final Date timeEnd;
    @JsonProperty(value="timeFirstSeen")
    private final Date timeFirstSeen;
    @JsonProperty(value="timeLastSeen")
    private final Date timeLastSeen;

    @Deprecated
    @ConstructorProperties(value={"libraryKey", "fleetId", "libraryName", "libraryVersion", "cvssScore", "approximateApplicationCount", "approximateJavaServerInstanceCount", "approximateDeployedApplicationCount", "approximateManagedInstanceCount", "timeStart", "timeEnd", "timeFirstSeen", "timeLastSeen"})
    public LibraryUsage(String libraryKey, String fleetId, String libraryName, String libraryVersion, Float cvssScore, Integer approximateApplicationCount, Integer approximateJavaServerInstanceCount, Integer approximateDeployedApplicationCount, Integer approximateManagedInstanceCount, Date timeStart, Date timeEnd, Date timeFirstSeen, Date timeLastSeen) {
        this.libraryKey = libraryKey;
        this.fleetId = fleetId;
        this.libraryName = libraryName;
        this.libraryVersion = libraryVersion;
        this.cvssScore = cvssScore;
        this.approximateApplicationCount = approximateApplicationCount;
        this.approximateJavaServerInstanceCount = approximateJavaServerInstanceCount;
        this.approximateDeployedApplicationCount = approximateDeployedApplicationCount;
        this.approximateManagedInstanceCount = approximateManagedInstanceCount;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.timeFirstSeen = timeFirstSeen;
        this.timeLastSeen = timeLastSeen;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getLibraryKey() {
        return this.libraryKey;
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public String getLibraryVersion() {
        return this.libraryVersion;
    }

    public Float getCvssScore() {
        return this.cvssScore;
    }

    public Integer getApproximateApplicationCount() {
        return this.approximateApplicationCount;
    }

    public Integer getApproximateJavaServerInstanceCount() {
        return this.approximateJavaServerInstanceCount;
    }

    public Integer getApproximateDeployedApplicationCount() {
        return this.approximateDeployedApplicationCount;
    }

    public Integer getApproximateManagedInstanceCount() {
        return this.approximateManagedInstanceCount;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Date getTimeFirstSeen() {
        return this.timeFirstSeen;
    }

    public Date getTimeLastSeen() {
        return this.timeLastSeen;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LibraryUsage(");
        sb.append("super=").append(super.toString());
        sb.append("libraryKey=").append(String.valueOf(this.libraryKey));
        sb.append(", fleetId=").append(String.valueOf(this.fleetId));
        sb.append(", libraryName=").append(String.valueOf(this.libraryName));
        sb.append(", libraryVersion=").append(String.valueOf(this.libraryVersion));
        sb.append(", cvssScore=").append(String.valueOf(this.cvssScore));
        sb.append(", approximateApplicationCount=").append(String.valueOf(this.approximateApplicationCount));
        sb.append(", approximateJavaServerInstanceCount=").append(String.valueOf(this.approximateJavaServerInstanceCount));
        sb.append(", approximateDeployedApplicationCount=").append(String.valueOf(this.approximateDeployedApplicationCount));
        sb.append(", approximateManagedInstanceCount=").append(String.valueOf(this.approximateManagedInstanceCount));
        sb.append(", timeStart=").append(String.valueOf(this.timeStart));
        sb.append(", timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(", timeFirstSeen=").append(String.valueOf(this.timeFirstSeen));
        sb.append(", timeLastSeen=").append(String.valueOf(this.timeLastSeen));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibraryUsage)) {
            return false;
        }
        LibraryUsage other = (LibraryUsage)((Object)o);
        return Objects.equals(this.libraryKey, other.libraryKey) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals(this.libraryName, other.libraryName) && Objects.equals(this.libraryVersion, other.libraryVersion) && Objects.equals(this.cvssScore, other.cvssScore) && Objects.equals(this.approximateApplicationCount, other.approximateApplicationCount) && Objects.equals(this.approximateJavaServerInstanceCount, other.approximateJavaServerInstanceCount) && Objects.equals(this.approximateDeployedApplicationCount, other.approximateDeployedApplicationCount) && Objects.equals(this.approximateManagedInstanceCount, other.approximateManagedInstanceCount) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.timeFirstSeen, other.timeFirstSeen) && Objects.equals(this.timeLastSeen, other.timeLastSeen) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.libraryKey == null ? 43 : this.libraryKey.hashCode());
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.libraryName == null ? 43 : this.libraryName.hashCode());
        result = result * 59 + (this.libraryVersion == null ? 43 : this.libraryVersion.hashCode());
        result = result * 59 + (this.cvssScore == null ? 43 : this.cvssScore.hashCode());
        result = result * 59 + (this.approximateApplicationCount == null ? 43 : this.approximateApplicationCount.hashCode());
        result = result * 59 + (this.approximateJavaServerInstanceCount == null ? 43 : this.approximateJavaServerInstanceCount.hashCode());
        result = result * 59 + (this.approximateDeployedApplicationCount == null ? 43 : this.approximateDeployedApplicationCount.hashCode());
        result = result * 59 + (this.approximateManagedInstanceCount == null ? 43 : this.approximateManagedInstanceCount.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.timeFirstSeen == null ? 43 : this.timeFirstSeen.hashCode());
        result = result * 59 + (this.timeLastSeen == null ? 43 : this.timeLastSeen.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="libraryKey")
        private String libraryKey;
        @JsonProperty(value="fleetId")
        private String fleetId;
        @JsonProperty(value="libraryName")
        private String libraryName;
        @JsonProperty(value="libraryVersion")
        private String libraryVersion;
        @JsonProperty(value="cvssScore")
        private Float cvssScore;
        @JsonProperty(value="approximateApplicationCount")
        private Integer approximateApplicationCount;
        @JsonProperty(value="approximateJavaServerInstanceCount")
        private Integer approximateJavaServerInstanceCount;
        @JsonProperty(value="approximateDeployedApplicationCount")
        private Integer approximateDeployedApplicationCount;
        @JsonProperty(value="approximateManagedInstanceCount")
        private Integer approximateManagedInstanceCount;
        @JsonProperty(value="timeStart")
        private Date timeStart;
        @JsonProperty(value="timeEnd")
        private Date timeEnd;
        @JsonProperty(value="timeFirstSeen")
        private Date timeFirstSeen;
        @JsonProperty(value="timeLastSeen")
        private Date timeLastSeen;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder libraryKey(String libraryKey) {
            this.libraryKey = libraryKey;
            this.__explicitlySet__.add("libraryKey");
            return this;
        }

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            this.__explicitlySet__.add("fleetId");
            return this;
        }

        public Builder libraryName(String libraryName) {
            this.libraryName = libraryName;
            this.__explicitlySet__.add("libraryName");
            return this;
        }

        public Builder libraryVersion(String libraryVersion) {
            this.libraryVersion = libraryVersion;
            this.__explicitlySet__.add("libraryVersion");
            return this;
        }

        public Builder cvssScore(Float cvssScore) {
            this.cvssScore = cvssScore;
            this.__explicitlySet__.add("cvssScore");
            return this;
        }

        public Builder approximateApplicationCount(Integer approximateApplicationCount) {
            this.approximateApplicationCount = approximateApplicationCount;
            this.__explicitlySet__.add("approximateApplicationCount");
            return this;
        }

        public Builder approximateJavaServerInstanceCount(Integer approximateJavaServerInstanceCount) {
            this.approximateJavaServerInstanceCount = approximateJavaServerInstanceCount;
            this.__explicitlySet__.add("approximateJavaServerInstanceCount");
            return this;
        }

        public Builder approximateDeployedApplicationCount(Integer approximateDeployedApplicationCount) {
            this.approximateDeployedApplicationCount = approximateDeployedApplicationCount;
            this.__explicitlySet__.add("approximateDeployedApplicationCount");
            return this;
        }

        public Builder approximateManagedInstanceCount(Integer approximateManagedInstanceCount) {
            this.approximateManagedInstanceCount = approximateManagedInstanceCount;
            this.__explicitlySet__.add("approximateManagedInstanceCount");
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            this.__explicitlySet__.add("timeStart");
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            this.__explicitlySet__.add("timeEnd");
            return this;
        }

        public Builder timeFirstSeen(Date timeFirstSeen) {
            this.timeFirstSeen = timeFirstSeen;
            this.__explicitlySet__.add("timeFirstSeen");
            return this;
        }

        public Builder timeLastSeen(Date timeLastSeen) {
            this.timeLastSeen = timeLastSeen;
            this.__explicitlySet__.add("timeLastSeen");
            return this;
        }

        public LibraryUsage build() {
            LibraryUsage model = new LibraryUsage(this.libraryKey, this.fleetId, this.libraryName, this.libraryVersion, this.cvssScore, this.approximateApplicationCount, this.approximateJavaServerInstanceCount, this.approximateDeployedApplicationCount, this.approximateManagedInstanceCount, this.timeStart, this.timeEnd, this.timeFirstSeen, this.timeLastSeen);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LibraryUsage model) {
            if (model.wasPropertyExplicitlySet("libraryKey")) {
                this.libraryKey(model.getLibraryKey());
            }
            if (model.wasPropertyExplicitlySet("fleetId")) {
                this.fleetId(model.getFleetId());
            }
            if (model.wasPropertyExplicitlySet("libraryName")) {
                this.libraryName(model.getLibraryName());
            }
            if (model.wasPropertyExplicitlySet("libraryVersion")) {
                this.libraryVersion(model.getLibraryVersion());
            }
            if (model.wasPropertyExplicitlySet("cvssScore")) {
                this.cvssScore(model.getCvssScore());
            }
            if (model.wasPropertyExplicitlySet("approximateApplicationCount")) {
                this.approximateApplicationCount(model.getApproximateApplicationCount());
            }
            if (model.wasPropertyExplicitlySet("approximateJavaServerInstanceCount")) {
                this.approximateJavaServerInstanceCount(model.getApproximateJavaServerInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("approximateDeployedApplicationCount")) {
                this.approximateDeployedApplicationCount(model.getApproximateDeployedApplicationCount());
            }
            if (model.wasPropertyExplicitlySet("approximateManagedInstanceCount")) {
                this.approximateManagedInstanceCount(model.getApproximateManagedInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("timeStart")) {
                this.timeStart(model.getTimeStart());
            }
            if (model.wasPropertyExplicitlySet("timeEnd")) {
                this.timeEnd(model.getTimeEnd());
            }
            if (model.wasPropertyExplicitlySet("timeFirstSeen")) {
                this.timeFirstSeen(model.getTimeFirstSeen());
            }
            if (model.wasPropertyExplicitlySet("timeLastSeen")) {
                this.timeLastSeen(model.getTimeLastSeen());
            }
            return this;
        }
    }
}

