/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BlocklistTarget
extends ExplicitlySetBmcModel {
    @JsonProperty(value="fleetId")
    private final String fleetId;
    @JsonProperty(value="managedInstanceId")
    private final String managedInstanceId;
    @JsonProperty(value="installationKey")
    private final String installationKey;

    @Deprecated
    @ConstructorProperties(value={"fleetId", "managedInstanceId", "installationKey"})
    public BlocklistTarget(String fleetId, String managedInstanceId, String installationKey) {
        this.fleetId = fleetId;
        this.managedInstanceId = managedInstanceId;
        this.installationKey = installationKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getInstallationKey() {
        return this.installationKey;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BlocklistTarget(");
        sb.append("super=").append(super.toString());
        sb.append("fleetId=").append(String.valueOf(this.fleetId));
        sb.append(", managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(", installationKey=").append(String.valueOf(this.installationKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlocklistTarget)) {
            return false;
        }
        BlocklistTarget other = (BlocklistTarget)((Object)o);
        return Objects.equals(this.fleetId, other.fleetId) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.installationKey, other.installationKey) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.installationKey == null ? 43 : this.installationKey.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fleetId")
        private String fleetId;
        @JsonProperty(value="managedInstanceId")
        private String managedInstanceId;
        @JsonProperty(value="installationKey")
        private String installationKey;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            this.__explicitlySet__.add("fleetId");
            return this;
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            this.__explicitlySet__.add("managedInstanceId");
            return this;
        }

        public Builder installationKey(String installationKey) {
            this.installationKey = installationKey;
            this.__explicitlySet__.add("installationKey");
            return this;
        }

        public BlocklistTarget build() {
            BlocklistTarget model = new BlocklistTarget(this.fleetId, this.managedInstanceId, this.installationKey);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BlocklistTarget model) {
            if (model.wasPropertyExplicitlySet("fleetId")) {
                this.fleetId(model.getFleetId());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceId")) {
                this.managedInstanceId(model.getManagedInstanceId());
            }
            if (model.wasPropertyExplicitlySet("installationKey")) {
                this.installationKey(model.getInstallationKey());
            }
            return this;
        }
    }
}

