/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.integration.model.UpdateIntegrationInstanceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateIntegrationInstanceRequest
extends BmcRequest<UpdateIntegrationInstanceDetails> {
    private String integrationInstanceId;
    private UpdateIntegrationInstanceDetails updateIntegrationInstanceDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getIntegrationInstanceId() {
        return this.integrationInstanceId;
    }

    public UpdateIntegrationInstanceDetails getUpdateIntegrationInstanceDetails() {
        return this.updateIntegrationInstanceDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateIntegrationInstanceDetails getBody$() {
        return this.updateIntegrationInstanceDetails;
    }

    public Builder toBuilder() {
        return new Builder().integrationInstanceId(this.integrationInstanceId).updateIntegrationInstanceDetails(this.updateIntegrationInstanceDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",integrationInstanceId=").append(String.valueOf(this.integrationInstanceId));
        sb.append(",updateIntegrationInstanceDetails=").append(String.valueOf((Object)this.updateIntegrationInstanceDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateIntegrationInstanceRequest)) {
            return false;
        }
        UpdateIntegrationInstanceRequest other = (UpdateIntegrationInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.integrationInstanceId, other.integrationInstanceId) && Objects.equals((Object)this.updateIntegrationInstanceDetails, (Object)other.updateIntegrationInstanceDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.integrationInstanceId == null ? 43 : this.integrationInstanceId.hashCode());
        result = result * 59 + (this.updateIntegrationInstanceDetails == null ? 43 : this.updateIntegrationInstanceDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateIntegrationInstanceRequest, UpdateIntegrationInstanceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String integrationInstanceId = null;
        private UpdateIntegrationInstanceDetails updateIntegrationInstanceDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder integrationInstanceId(String integrationInstanceId) {
            this.integrationInstanceId = integrationInstanceId;
            return this;
        }

        public Builder updateIntegrationInstanceDetails(UpdateIntegrationInstanceDetails updateIntegrationInstanceDetails) {
            this.updateIntegrationInstanceDetails = updateIntegrationInstanceDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateIntegrationInstanceRequest o) {
            this.integrationInstanceId(o.getIntegrationInstanceId());
            this.updateIntegrationInstanceDetails(o.getUpdateIntegrationInstanceDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateIntegrationInstanceRequest build() {
            UpdateIntegrationInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateIntegrationInstanceDetails body) {
            this.updateIntegrationInstanceDetails(body);
            return this;
        }

        public UpdateIntegrationInstanceRequest buildWithoutInvocationCallback() {
            UpdateIntegrationInstanceRequest request = new UpdateIntegrationInstanceRequest();
            request.integrationInstanceId = this.integrationInstanceId;
            request.updateIntegrationInstanceDetails = this.updateIntegrationInstanceDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

