/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OnBehalfOfRequest
extends ExplicitlySetBmcModel {
    @JsonProperty(value="requestHeaders")
    private final Map<String, List<String>> requestHeaders;
    @JsonProperty(value="targetServiceName")
    private final String targetServiceName;
    @JsonProperty(value="oboToken")
    private final String oboToken;
    @JsonProperty(value="expiration")
    private final String expiration;

    @Deprecated
    @ConstructorProperties(value={"requestHeaders", "targetServiceName", "oboToken", "expiration"})
    public OnBehalfOfRequest(Map<String, List<String>> requestHeaders, String targetServiceName, String oboToken, String expiration) {
        this.requestHeaders = requestHeaders;
        this.targetServiceName = targetServiceName;
        this.oboToken = oboToken;
        this.expiration = expiration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Map<String, List<String>> getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getTargetServiceName() {
        return this.targetServiceName;
    }

    public String getOboToken() {
        return this.oboToken;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OnBehalfOfRequest(");
        sb.append("super=").append(super.toString());
        sb.append("requestHeaders=").append(String.valueOf(this.requestHeaders));
        sb.append(", targetServiceName=").append(String.valueOf(this.targetServiceName));
        sb.append(", oboToken=").append(String.valueOf(this.oboToken));
        sb.append(", expiration=").append(String.valueOf(this.expiration));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OnBehalfOfRequest)) {
            return false;
        }
        OnBehalfOfRequest other = (OnBehalfOfRequest)((Object)o);
        return Objects.equals(this.requestHeaders, other.requestHeaders) && Objects.equals(this.targetServiceName, other.targetServiceName) && Objects.equals(this.oboToken, other.oboToken) && Objects.equals(this.expiration, other.expiration) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.requestHeaders == null ? 43 : this.requestHeaders.hashCode());
        result = result * 59 + (this.targetServiceName == null ? 43 : this.targetServiceName.hashCode());
        result = result * 59 + (this.oboToken == null ? 43 : this.oboToken.hashCode());
        result = result * 59 + (this.expiration == null ? 43 : this.expiration.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="requestHeaders")
        private Map<String, List<String>> requestHeaders;
        @JsonProperty(value="targetServiceName")
        private String targetServiceName;
        @JsonProperty(value="oboToken")
        private String oboToken;
        @JsonProperty(value="expiration")
        private String expiration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder requestHeaders(Map<String, List<String>> requestHeaders) {
            this.requestHeaders = requestHeaders;
            this.__explicitlySet__.add("requestHeaders");
            return this;
        }

        public Builder targetServiceName(String targetServiceName) {
            this.targetServiceName = targetServiceName;
            this.__explicitlySet__.add("targetServiceName");
            return this;
        }

        public Builder oboToken(String oboToken) {
            this.oboToken = oboToken;
            this.__explicitlySet__.add("oboToken");
            return this;
        }

        public Builder expiration(String expiration) {
            this.expiration = expiration;
            this.__explicitlySet__.add("expiration");
            return this;
        }

        public OnBehalfOfRequest build() {
            OnBehalfOfRequest model = new OnBehalfOfRequest(this.requestHeaders, this.targetServiceName, this.oboToken, this.expiration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OnBehalfOfRequest model) {
            if (model.wasPropertyExplicitlySet("requestHeaders")) {
                this.requestHeaders(model.getRequestHeaders());
            }
            if (model.wasPropertyExplicitlySet("targetServiceName")) {
                this.targetServiceName(model.getTargetServiceName());
            }
            if (model.wasPropertyExplicitlySet("oboToken")) {
                this.oboToken(model.getOboToken());
            }
            if (model.wasPropertyExplicitlySet("expiration")) {
                this.expiration(model.getExpiration());
            }
            return this;
        }
    }
}

