/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JWK
extends ExplicitlySetBmcModel {
    @JsonProperty(value="n")
    private final String n;
    @JsonProperty(value="e")
    private final String e;
    @JsonProperty(value="kid")
    private final String kid;
    @JsonProperty(value="use")
    private final String use;
    @JsonProperty(value="alg")
    private final String alg;
    @JsonProperty(value="kty")
    private final String kty;

    @Deprecated
    @ConstructorProperties(value={"n", "e", "kid", "use", "alg", "kty"})
    public JWK(String n, String e, String kid, String use, String alg, String kty) {
        this.n = n;
        this.e = e;
        this.kid = kid;
        this.use = use;
        this.alg = alg;
        this.kty = kty;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getN() {
        return this.n;
    }

    public String getE() {
        return this.e;
    }

    public String getKid() {
        return this.kid;
    }

    public String getUse() {
        return this.use;
    }

    public String getAlg() {
        return this.alg;
    }

    public String getKty() {
        return this.kty;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JWK(");
        sb.append("super=").append(super.toString());
        sb.append("n=").append(String.valueOf(this.n));
        sb.append(", e=").append(String.valueOf(this.e));
        sb.append(", kid=").append(String.valueOf(this.kid));
        sb.append(", use=").append(String.valueOf(this.use));
        sb.append(", alg=").append(String.valueOf(this.alg));
        sb.append(", kty=").append(String.valueOf(this.kty));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JWK)) {
            return false;
        }
        JWK other = (JWK)((Object)o);
        return Objects.equals(this.n, other.n) && Objects.equals(this.e, other.e) && Objects.equals(this.kid, other.kid) && Objects.equals(this.use, other.use) && Objects.equals(this.alg, other.alg) && Objects.equals(this.kty, other.kty) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.n == null ? 43 : this.n.hashCode());
        result = result * 59 + (this.e == null ? 43 : this.e.hashCode());
        result = result * 59 + (this.kid == null ? 43 : this.kid.hashCode());
        result = result * 59 + (this.use == null ? 43 : this.use.hashCode());
        result = result * 59 + (this.alg == null ? 43 : this.alg.hashCode());
        result = result * 59 + (this.kty == null ? 43 : this.kty.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="n")
        private String n;
        @JsonProperty(value="e")
        private String e;
        @JsonProperty(value="kid")
        private String kid;
        @JsonProperty(value="use")
        private String use;
        @JsonProperty(value="alg")
        private String alg;
        @JsonProperty(value="kty")
        private String kty;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder n(String n) {
            this.n = n;
            this.__explicitlySet__.add("n");
            return this;
        }

        public Builder e(String e) {
            this.e = e;
            this.__explicitlySet__.add("e");
            return this;
        }

        public Builder kid(String kid) {
            this.kid = kid;
            this.__explicitlySet__.add("kid");
            return this;
        }

        public Builder use(String use) {
            this.use = use;
            this.__explicitlySet__.add("use");
            return this;
        }

        public Builder alg(String alg) {
            this.alg = alg;
            this.__explicitlySet__.add("alg");
            return this;
        }

        public Builder kty(String kty) {
            this.kty = kty;
            this.__explicitlySet__.add("kty");
            return this;
        }

        public JWK build() {
            JWK model = new JWK(this.n, this.e, this.kid, this.use, this.alg, this.kty);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JWK model) {
            if (model.wasPropertyExplicitlySet("n")) {
                this.n(model.getN());
            }
            if (model.wasPropertyExplicitlySet("e")) {
                this.e(model.getE());
            }
            if (model.wasPropertyExplicitlySet("kid")) {
                this.kid(model.getKid());
            }
            if (model.wasPropertyExplicitlySet("use")) {
                this.use(model.getUse());
            }
            if (model.wasPropertyExplicitlySet("alg")) {
                this.alg(model.getAlg());
            }
            if (model.wasPropertyExplicitlySet("kty")) {
                this.kty(model.getKty());
            }
            return this;
        }
    }
}

