/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.identitydataplane.model.EntityStatus;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Compartment
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="fullName")
    private final String fullName;
    @JsonProperty(value="parentCompartmentId")
    private final String parentCompartmentId;
    @JsonProperty(value="status")
    private final EntityStatus status;
    @JsonProperty(value="propertyMap")
    private final Map<String, String> propertyMap;

    @Deprecated
    @ConstructorProperties(value={"id", "name", "displayName", "fullName", "parentCompartmentId", "status", "propertyMap"})
    public Compartment(String id, String name, String displayName, String fullName, String parentCompartmentId, EntityStatus status, Map<String, String> propertyMap) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.fullName = fullName;
        this.parentCompartmentId = parentCompartmentId;
        this.status = status;
        this.propertyMap = propertyMap;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getParentCompartmentId() {
        return this.parentCompartmentId;
    }

    public EntityStatus getStatus() {
        return this.status;
    }

    public Map<String, String> getPropertyMap() {
        return this.propertyMap;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Compartment(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", fullName=").append(String.valueOf(this.fullName));
        sb.append(", parentCompartmentId=").append(String.valueOf(this.parentCompartmentId));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", propertyMap=").append(String.valueOf(this.propertyMap));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Compartment)) {
            return false;
        }
        Compartment other = (Compartment)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.fullName, other.fullName) && Objects.equals(this.parentCompartmentId, other.parentCompartmentId) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.propertyMap, other.propertyMap) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.fullName == null ? 43 : this.fullName.hashCode());
        result = result * 59 + (this.parentCompartmentId == null ? 43 : this.parentCompartmentId.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.propertyMap == null ? 43 : this.propertyMap.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="fullName")
        private String fullName;
        @JsonProperty(value="parentCompartmentId")
        private String parentCompartmentId;
        @JsonProperty(value="status")
        private EntityStatus status;
        @JsonProperty(value="propertyMap")
        private Map<String, String> propertyMap;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder fullName(String fullName) {
            this.fullName = fullName;
            this.__explicitlySet__.add("fullName");
            return this;
        }

        public Builder parentCompartmentId(String parentCompartmentId) {
            this.parentCompartmentId = parentCompartmentId;
            this.__explicitlySet__.add("parentCompartmentId");
            return this;
        }

        public Builder status(EntityStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder propertyMap(Map<String, String> propertyMap) {
            this.propertyMap = propertyMap;
            this.__explicitlySet__.add("propertyMap");
            return this;
        }

        public Compartment build() {
            Compartment model = new Compartment(this.id, this.name, this.displayName, this.fullName, this.parentCompartmentId, this.status, this.propertyMap);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Compartment model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("fullName")) {
                this.fullName(model.getFullName());
            }
            if (model.wasPropertyExplicitlySet("parentCompartmentId")) {
                this.parentCompartmentId(model.getParentCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("propertyMap")) {
                this.propertyMap(model.getPropertyMap());
            }
            return this;
        }
    }
}

