/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ClientCredentialsResponse
extends ExplicitlySetBmcModel {
    @JsonProperty(value="access_token")
    private final String accessToken;
    @JsonProperty(value="token_type")
    private final String tokenType;
    @JsonProperty(value="expires_in")
    private final String expiresIn;

    @Deprecated
    @ConstructorProperties(value={"accessToken", "tokenType", "expiresIn"})
    public ClientCredentialsResponse(String accessToken, String tokenType, String expiresIn) {
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getExpiresIn() {
        return this.expiresIn;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ClientCredentialsResponse(");
        sb.append("super=").append(super.toString());
        sb.append("accessToken=").append(String.valueOf(this.accessToken));
        sb.append(", tokenType=").append(String.valueOf(this.tokenType));
        sb.append(", expiresIn=").append(String.valueOf(this.expiresIn));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientCredentialsResponse)) {
            return false;
        }
        ClientCredentialsResponse other = (ClientCredentialsResponse)((Object)o);
        return Objects.equals(this.accessToken, other.accessToken) && Objects.equals(this.tokenType, other.tokenType) && Objects.equals(this.expiresIn, other.expiresIn) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.accessToken == null ? 43 : this.accessToken.hashCode());
        result = result * 59 + (this.tokenType == null ? 43 : this.tokenType.hashCode());
        result = result * 59 + (this.expiresIn == null ? 43 : this.expiresIn.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="access_token")
        private String accessToken;
        @JsonProperty(value="token_type")
        private String tokenType;
        @JsonProperty(value="expires_in")
        private String expiresIn;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            this.__explicitlySet__.add("accessToken");
            return this;
        }

        public Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            this.__explicitlySet__.add("tokenType");
            return this;
        }

        public Builder expiresIn(String expiresIn) {
            this.expiresIn = expiresIn;
            this.__explicitlySet__.add("expiresIn");
            return this;
        }

        public ClientCredentialsResponse build() {
            ClientCredentialsResponse model = new ClientCredentialsResponse(this.accessToken, this.tokenType, this.expiresIn);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ClientCredentialsResponse model) {
            if (model.wasPropertyExplicitlySet("accessToken")) {
                this.accessToken(model.getAccessToken());
            }
            if (model.wasPropertyExplicitlySet("tokenType")) {
                this.tokenType(model.getTokenType());
            }
            if (model.wasPropertyExplicitlySet("expiresIn")) {
                this.expiresIn(model.getExpiresIn());
            }
            return this;
        }
    }
}

