/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.governancerulescontrolplane;

import com.oracle.bmc.governancerulescontrolplane.GovernanceRule;
import com.oracle.bmc.governancerulescontrolplane.model.GovernanceRuleLifecycleState;
import com.oracle.bmc.governancerulescontrolplane.model.InclusionCriterion;
import com.oracle.bmc.governancerulescontrolplane.model.TenancyAttachment;
import com.oracle.bmc.governancerulescontrolplane.requests.GetEnforcedGovernanceRuleRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.GetGovernanceRuleRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.GetInclusionCriterionRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.GetTenancyAttachmentRequest;
import com.oracle.bmc.governancerulescontrolplane.responses.GetEnforcedGovernanceRuleResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.GetGovernanceRuleResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.GetInclusionCriterionResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.GetTenancyAttachmentResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class GovernanceRuleWaiters {
    private final ExecutorService executorService;
    private final GovernanceRule client;

    public GovernanceRuleWaiters(ExecutorService executorService, GovernanceRule client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetEnforcedGovernanceRuleRequest, GetEnforcedGovernanceRuleResponse> forEnforcedGovernanceRule(GetEnforcedGovernanceRuleRequest request, GovernanceRuleLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEnforcedGovernanceRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetEnforcedGovernanceRuleRequest, GetEnforcedGovernanceRuleResponse> forEnforcedGovernanceRule(GetEnforcedGovernanceRuleRequest request, GovernanceRuleLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forEnforcedGovernanceRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetEnforcedGovernanceRuleRequest, GetEnforcedGovernanceRuleResponse> forEnforcedGovernanceRule(GetEnforcedGovernanceRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, GovernanceRuleLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEnforcedGovernanceRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetEnforcedGovernanceRuleRequest, GetEnforcedGovernanceRuleResponse> forEnforcedGovernanceRule(BmcGenericWaiter waiter, GetEnforcedGovernanceRuleRequest request, GovernanceRuleLifecycleState ... targetStates) {
        final HashSet<GovernanceRuleLifecycleState> targetStatesSet = new HashSet<GovernanceRuleLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetEnforcedGovernanceRuleRequest, GetEnforcedGovernanceRuleResponse>(){

            @Override
            public GetEnforcedGovernanceRuleResponse apply(GetEnforcedGovernanceRuleRequest request) {
                return GovernanceRuleWaiters.this.client.getEnforcedGovernanceRule(request);
            }
        }, (Predicate)new Predicate<GetEnforcedGovernanceRuleResponse>(){

            @Override
            public boolean test(GetEnforcedGovernanceRuleResponse response) {
                return targetStatesSet.contains((Object)response.getEnforcedGovernanceRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)GovernanceRuleLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetGovernanceRuleRequest, GetGovernanceRuleResponse> forGovernanceRule(GetGovernanceRuleRequest request, GovernanceRuleLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forGovernanceRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetGovernanceRuleRequest, GetGovernanceRuleResponse> forGovernanceRule(GetGovernanceRuleRequest request, GovernanceRuleLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forGovernanceRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetGovernanceRuleRequest, GetGovernanceRuleResponse> forGovernanceRule(GetGovernanceRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, GovernanceRuleLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forGovernanceRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetGovernanceRuleRequest, GetGovernanceRuleResponse> forGovernanceRule(BmcGenericWaiter waiter, GetGovernanceRuleRequest request, GovernanceRuleLifecycleState ... targetStates) {
        final HashSet<GovernanceRuleLifecycleState> targetStatesSet = new HashSet<GovernanceRuleLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetGovernanceRuleRequest, GetGovernanceRuleResponse>(){

            @Override
            public GetGovernanceRuleResponse apply(GetGovernanceRuleRequest request) {
                return GovernanceRuleWaiters.this.client.getGovernanceRule(request);
            }
        }, (Predicate)new Predicate<GetGovernanceRuleResponse>(){

            @Override
            public boolean test(GetGovernanceRuleResponse response) {
                return targetStatesSet.contains((Object)response.getGovernanceRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)GovernanceRuleLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetInclusionCriterionRequest, GetInclusionCriterionResponse> forInclusionCriterion(GetInclusionCriterionRequest request, InclusionCriterion.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forInclusionCriterion(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetInclusionCriterionRequest, GetInclusionCriterionResponse> forInclusionCriterion(GetInclusionCriterionRequest request, InclusionCriterion.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forInclusionCriterion(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetInclusionCriterionRequest, GetInclusionCriterionResponse> forInclusionCriterion(GetInclusionCriterionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, InclusionCriterion.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forInclusionCriterion(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetInclusionCriterionRequest, GetInclusionCriterionResponse> forInclusionCriterion(BmcGenericWaiter waiter, GetInclusionCriterionRequest request, InclusionCriterion.LifecycleState ... targetStates) {
        final HashSet<InclusionCriterion.LifecycleState> targetStatesSet = new HashSet<InclusionCriterion.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetInclusionCriterionRequest, GetInclusionCriterionResponse>(){

            @Override
            public GetInclusionCriterionResponse apply(GetInclusionCriterionRequest request) {
                return GovernanceRuleWaiters.this.client.getInclusionCriterion(request);
            }
        }, (Predicate)new Predicate<GetInclusionCriterionResponse>(){

            @Override
            public boolean test(GetInclusionCriterionResponse response) {
                return targetStatesSet.contains((Object)response.getInclusionCriterion().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)InclusionCriterion.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTenancyAttachmentRequest, GetTenancyAttachmentResponse> forTenancyAttachment(GetTenancyAttachmentRequest request, TenancyAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTenancyAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTenancyAttachmentRequest, GetTenancyAttachmentResponse> forTenancyAttachment(GetTenancyAttachmentRequest request, TenancyAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTenancyAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTenancyAttachmentRequest, GetTenancyAttachmentResponse> forTenancyAttachment(GetTenancyAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, TenancyAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTenancyAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTenancyAttachmentRequest, GetTenancyAttachmentResponse> forTenancyAttachment(BmcGenericWaiter waiter, GetTenancyAttachmentRequest request, TenancyAttachment.LifecycleState ... targetStates) {
        final HashSet<TenancyAttachment.LifecycleState> targetStatesSet = new HashSet<TenancyAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTenancyAttachmentRequest, GetTenancyAttachmentResponse>(){

            @Override
            public GetTenancyAttachmentResponse apply(GetTenancyAttachmentRequest request) {
                return GovernanceRuleWaiters.this.client.getTenancyAttachment(request);
            }
        }, (Predicate)new Predicate<GetTenancyAttachmentResponse>(){

            @Override
            public boolean test(GetTenancyAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getTenancyAttachment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)TenancyAttachment.LifecycleState.Deleted)), (Object)request);
    }
}

