/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.governancerulescontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.governancerulescontrolplane.GovernanceRuleAsyncClient;
import com.oracle.bmc.governancerulescontrolplane.GovernanceRulePaginators;
import com.oracle.bmc.governancerulescontrolplane.GovernanceRuleWaiters;
import com.oracle.bmc.governancerulescontrolplane.model.EnforcedGovernanceRule;
import com.oracle.bmc.governancerulescontrolplane.model.EnforcedGovernanceRuleCollection;
import com.oracle.bmc.governancerulescontrolplane.model.GovernanceRule;
import com.oracle.bmc.governancerulescontrolplane.model.GovernanceRuleCollection;
import com.oracle.bmc.governancerulescontrolplane.model.InclusionCriterion;
import com.oracle.bmc.governancerulescontrolplane.model.InclusionCriterionCollection;
import com.oracle.bmc.governancerulescontrolplane.model.TenancyAttachment;
import com.oracle.bmc.governancerulescontrolplane.model.TenancyAttachmentCollection;
import com.oracle.bmc.governancerulescontrolplane.requests.CreateGovernanceRuleRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.CreateInclusionCriterionRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.DeleteGovernanceRuleRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.DeleteInclusionCriterionRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.GetEnforcedGovernanceRuleRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.GetGovernanceRuleRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.GetInclusionCriterionRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.GetTenancyAttachmentRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.ListEnforcedGovernanceRulesRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.ListGovernanceRulesRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.ListInclusionCriteriaRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.ListTenancyAttachmentsRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.RetryGovernanceRuleRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.RetryTenancyAttachmentRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.UpdateGovernanceRuleRequest;
import com.oracle.bmc.governancerulescontrolplane.responses.CreateGovernanceRuleResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.CreateInclusionCriterionResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.DeleteGovernanceRuleResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.DeleteInclusionCriterionResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.GetEnforcedGovernanceRuleResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.GetGovernanceRuleResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.GetInclusionCriterionResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.GetTenancyAttachmentResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.ListEnforcedGovernanceRulesResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.ListGovernanceRulesResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.ListInclusionCriteriaResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.ListTenancyAttachmentsResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.RetryGovernanceRuleResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.RetryTenancyAttachmentResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.UpdateGovernanceRuleResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceRuleClient
extends BaseSyncClient
implements com.oracle.bmc.governancerulescontrolplane.GovernanceRule {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("GOVERNANCERULE").serviceEndpointPrefix("").serviceEndpointTemplate("https://governance-rules.organizations.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(GovernanceRuleAsyncClient.class);
    private final GovernanceRuleWaiters waiters;
    private final GovernanceRulePaginators paginators;

    private GovernanceRuleClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("GovernanceRule-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new GovernanceRuleWaiters(executorService, this);
        this.paginators = new GovernanceRulePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateGovernanceRuleResponse createGovernanceRule(CreateGovernanceRuleRequest request) {
        Objects.requireNonNull(request.getCreateGovernanceRuleDetails(), "createGovernanceRuleDetails is required");
        return (CreateGovernanceRuleResponse)this.clientCall(request, CreateGovernanceRuleResponse::builder).logger(LOG, "createGovernanceRule").serviceDetails("GovernanceRule", "CreateGovernanceRule", "").method(Method.POST).requestBuilder(CreateGovernanceRuleRequest::builder).basePath("/20220504").appendPathParam("governanceRules").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(GovernanceRule.class, CreateGovernanceRuleResponse.Builder::governanceRule).handleResponseHeaderString("etag", CreateGovernanceRuleResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateGovernanceRuleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateGovernanceRuleResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateGovernanceRuleResponse.Builder::location).callSync();
    }

    @Override
    public CreateInclusionCriterionResponse createInclusionCriterion(CreateInclusionCriterionRequest request) {
        Objects.requireNonNull(request.getCreateInclusionCriterionDetails(), "createInclusionCriterionDetails is required");
        return (CreateInclusionCriterionResponse)this.clientCall(request, CreateInclusionCriterionResponse::builder).logger(LOG, "createInclusionCriterion").serviceDetails("GovernanceRule", "CreateInclusionCriterion", "").method(Method.POST).requestBuilder(CreateInclusionCriterionRequest::builder).basePath("/20220504").appendPathParam("inclusionCriteria").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(InclusionCriterion.class, CreateInclusionCriterionResponse.Builder::inclusionCriterion).handleResponseHeaderString("etag", CreateInclusionCriterionResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateInclusionCriterionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateInclusionCriterionResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateInclusionCriterionResponse.Builder::location).callSync();
    }

    @Override
    public DeleteGovernanceRuleResponse deleteGovernanceRule(DeleteGovernanceRuleRequest request) {
        Validate.notBlank((String)request.getGovernanceRuleId(), (String)"governanceRuleId must not be blank", (Object[])new Object[0]);
        return (DeleteGovernanceRuleResponse)this.clientCall(request, DeleteGovernanceRuleResponse::builder).logger(LOG, "deleteGovernanceRule").serviceDetails("GovernanceRule", "DeleteGovernanceRule", "").method(Method.DELETE).requestBuilder(DeleteGovernanceRuleRequest::builder).basePath("/20220504").appendPathParam("governanceRules").appendPathParam(request.getGovernanceRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteGovernanceRuleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteGovernanceRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteInclusionCriterionResponse deleteInclusionCriterion(DeleteInclusionCriterionRequest request) {
        Validate.notBlank((String)request.getInclusionCriterionId(), (String)"inclusionCriterionId must not be blank", (Object[])new Object[0]);
        return (DeleteInclusionCriterionResponse)this.clientCall(request, DeleteInclusionCriterionResponse::builder).logger(LOG, "deleteInclusionCriterion").serviceDetails("GovernanceRule", "DeleteInclusionCriterion", "").method(Method.DELETE).requestBuilder(DeleteInclusionCriterionRequest::builder).basePath("/20220504").appendPathParam("inclusionCriteria").appendPathParam(request.getInclusionCriterionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteInclusionCriterionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteInclusionCriterionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetEnforcedGovernanceRuleResponse getEnforcedGovernanceRule(GetEnforcedGovernanceRuleRequest request) {
        Validate.notBlank((String)request.getEnforcedGovernanceRuleId(), (String)"enforcedGovernanceRuleId must not be blank", (Object[])new Object[0]);
        return (GetEnforcedGovernanceRuleResponse)this.clientCall(request, GetEnforcedGovernanceRuleResponse::builder).logger(LOG, "getEnforcedGovernanceRule").serviceDetails("GovernanceRule", "GetEnforcedGovernanceRule", "").method(Method.GET).requestBuilder(GetEnforcedGovernanceRuleRequest::builder).basePath("/20220504").appendPathParam("enforcedGovernanceRules").appendPathParam(request.getEnforcedGovernanceRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EnforcedGovernanceRule.class, GetEnforcedGovernanceRuleResponse.Builder::enforcedGovernanceRule).handleResponseHeaderString("etag", GetEnforcedGovernanceRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEnforcedGovernanceRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetGovernanceRuleResponse getGovernanceRule(GetGovernanceRuleRequest request) {
        Validate.notBlank((String)request.getGovernanceRuleId(), (String)"governanceRuleId must not be blank", (Object[])new Object[0]);
        return (GetGovernanceRuleResponse)this.clientCall(request, GetGovernanceRuleResponse::builder).logger(LOG, "getGovernanceRule").serviceDetails("GovernanceRule", "GetGovernanceRule", "").method(Method.GET).requestBuilder(GetGovernanceRuleRequest::builder).basePath("/20220504").appendPathParam("governanceRules").appendPathParam(request.getGovernanceRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(GovernanceRule.class, GetGovernanceRuleResponse.Builder::governanceRule).handleResponseHeaderString("etag", GetGovernanceRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetGovernanceRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetInclusionCriterionResponse getInclusionCriterion(GetInclusionCriterionRequest request) {
        Validate.notBlank((String)request.getInclusionCriterionId(), (String)"inclusionCriterionId must not be blank", (Object[])new Object[0]);
        return (GetInclusionCriterionResponse)this.clientCall(request, GetInclusionCriterionResponse::builder).logger(LOG, "getInclusionCriterion").serviceDetails("GovernanceRule", "GetInclusionCriterion", "").method(Method.GET).requestBuilder(GetInclusionCriterionRequest::builder).basePath("/20220504").appendPathParam("inclusionCriteria").appendPathParam(request.getInclusionCriterionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InclusionCriterion.class, GetInclusionCriterionResponse.Builder::inclusionCriterion).handleResponseHeaderString("etag", GetInclusionCriterionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetInclusionCriterionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetTenancyAttachmentResponse getTenancyAttachment(GetTenancyAttachmentRequest request) {
        Validate.notBlank((String)request.getTenancyAttachmentId(), (String)"tenancyAttachmentId must not be blank", (Object[])new Object[0]);
        return (GetTenancyAttachmentResponse)this.clientCall(request, GetTenancyAttachmentResponse::builder).logger(LOG, "getTenancyAttachment").serviceDetails("GovernanceRule", "GetTenancyAttachment", "").method(Method.GET).requestBuilder(GetTenancyAttachmentRequest::builder).basePath("/20220504").appendPathParam("tenancyAttachments").appendPathParam(request.getTenancyAttachmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TenancyAttachment.class, GetTenancyAttachmentResponse.Builder::tenancyAttachment).handleResponseHeaderString("etag", GetTenancyAttachmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTenancyAttachmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListEnforcedGovernanceRulesResponse listEnforcedGovernanceRules(ListEnforcedGovernanceRulesRequest request) {
        return (ListEnforcedGovernanceRulesResponse)this.clientCall(request, ListEnforcedGovernanceRulesResponse::builder).logger(LOG, "listEnforcedGovernanceRules").serviceDetails("GovernanceRule", "ListEnforcedGovernanceRules", "").method(Method.GET).requestBuilder(ListEnforcedGovernanceRulesRequest::builder).basePath("/20220504").appendPathParam("enforcedGovernanceRules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("enforcedGovernanceRuleId", (Object)request.getEnforcedGovernanceRuleId()).appendEnumQueryParam("governanceRuleType", (BmcEnum)request.getGovernanceRuleType()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EnforcedGovernanceRuleCollection.class, ListEnforcedGovernanceRulesResponse.Builder::enforcedGovernanceRuleCollection).handleResponseHeaderString("opc-request-id", ListEnforcedGovernanceRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEnforcedGovernanceRulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListGovernanceRulesResponse listGovernanceRules(ListGovernanceRulesRequest request) {
        return (ListGovernanceRulesResponse)this.clientCall(request, ListGovernanceRulesResponse::builder).logger(LOG, "listGovernanceRules").serviceDetails("GovernanceRule", "ListGovernanceRules", "").method(Method.GET).requestBuilder(ListGovernanceRulesRequest::builder).basePath("/20220504").appendPathParam("governanceRules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("governanceRuleId", (Object)request.getGovernanceRuleId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("governanceRuleType", (BmcEnum)request.getGovernanceRuleType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(GovernanceRuleCollection.class, ListGovernanceRulesResponse.Builder::governanceRuleCollection).handleResponseHeaderString("opc-request-id", ListGovernanceRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListGovernanceRulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListInclusionCriteriaResponse listInclusionCriteria(ListInclusionCriteriaRequest request) {
        Objects.requireNonNull(request.getGovernanceRuleId(), "governanceRuleId is required");
        return (ListInclusionCriteriaResponse)this.clientCall(request, ListInclusionCriteriaResponse::builder).logger(LOG, "listInclusionCriteria").serviceDetails("GovernanceRule", "ListInclusionCriteria", "").method(Method.GET).requestBuilder(ListInclusionCriteriaRequest::builder).basePath("/20220504").appendPathParam("inclusionCriteria").appendQueryParam("governanceRuleId", (Object)request.getGovernanceRuleId()).appendQueryParam("inclusionCriterionId", (Object)request.getInclusionCriterionId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InclusionCriterionCollection.class, ListInclusionCriteriaResponse.Builder::inclusionCriterionCollection).handleResponseHeaderString("opc-request-id", ListInclusionCriteriaResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListInclusionCriteriaResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListTenancyAttachmentsResponse listTenancyAttachments(ListTenancyAttachmentsRequest request) {
        return (ListTenancyAttachmentsResponse)this.clientCall(request, ListTenancyAttachmentsResponse::builder).logger(LOG, "listTenancyAttachments").serviceDetails("GovernanceRule", "ListTenancyAttachments", "").method(Method.GET).requestBuilder(ListTenancyAttachmentsRequest::builder).basePath("/20220504").appendPathParam("tenancyAttachments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("tenancyAttachmentId", (Object)request.getTenancyAttachmentId()).appendQueryParam("governanceRuleId", (Object)request.getGovernanceRuleId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("childTenancyId", (Object)request.getChildTenancyId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TenancyAttachmentCollection.class, ListTenancyAttachmentsResponse.Builder::tenancyAttachmentCollection).handleResponseHeaderString("opc-request-id", ListTenancyAttachmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTenancyAttachmentsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RetryGovernanceRuleResponse retryGovernanceRule(RetryGovernanceRuleRequest request) {
        Validate.notBlank((String)request.getGovernanceRuleId(), (String)"governanceRuleId must not be blank", (Object[])new Object[0]);
        return (RetryGovernanceRuleResponse)this.clientCall(request, RetryGovernanceRuleResponse::builder).logger(LOG, "retryGovernanceRule").serviceDetails("GovernanceRule", "RetryGovernanceRule", "").method(Method.POST).requestBuilder(RetryGovernanceRuleRequest::builder).basePath("/20220504").appendPathParam("governanceRules").appendPathParam(request.getGovernanceRuleId()).appendPathParam("actions").appendPathParam("retry").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", RetryGovernanceRuleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RetryGovernanceRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RetryTenancyAttachmentResponse retryTenancyAttachment(RetryTenancyAttachmentRequest request) {
        Validate.notBlank((String)request.getTenancyAttachmentId(), (String)"tenancyAttachmentId must not be blank", (Object[])new Object[0]);
        return (RetryTenancyAttachmentResponse)this.clientCall(request, RetryTenancyAttachmentResponse::builder).logger(LOG, "retryTenancyAttachment").serviceDetails("GovernanceRule", "RetryTenancyAttachment", "").method(Method.POST).requestBuilder(RetryTenancyAttachmentRequest::builder).basePath("/20220504").appendPathParam("tenancyAttachments").appendPathParam(request.getTenancyAttachmentId()).appendPathParam("actions").appendPathParam("retry").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", RetryTenancyAttachmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RetryTenancyAttachmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateGovernanceRuleResponse updateGovernanceRule(UpdateGovernanceRuleRequest request) {
        Validate.notBlank((String)request.getGovernanceRuleId(), (String)"governanceRuleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateGovernanceRuleDetails(), "updateGovernanceRuleDetails is required");
        return (UpdateGovernanceRuleResponse)this.clientCall(request, UpdateGovernanceRuleResponse::builder).logger(LOG, "updateGovernanceRule").serviceDetails("GovernanceRule", "UpdateGovernanceRule", "").method(Method.PUT).requestBuilder(UpdateGovernanceRuleRequest::builder).basePath("/20220504").appendPathParam("governanceRules").appendPathParam(request.getGovernanceRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateGovernanceRuleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateGovernanceRuleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GovernanceRuleWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public GovernanceRulePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public GovernanceRuleClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)GovernanceRuleClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public GovernanceRuleClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(GovernanceRuleClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public GovernanceRuleClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)GovernanceRuleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public GovernanceRuleClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)GovernanceRuleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public GovernanceRuleClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)GovernanceRuleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public GovernanceRuleClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)GovernanceRuleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public GovernanceRuleClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)GovernanceRuleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public GovernanceRuleClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)GovernanceRuleClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, GovernanceRuleClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public GovernanceRuleClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new GovernanceRuleClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

