/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.goldengate.model.StopDeploymentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class StopDeploymentRequest
extends BmcRequest<StopDeploymentDetails> {
    private String deploymentId;
    private StopDeploymentDetails stopDeploymentDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public StopDeploymentDetails getStopDeploymentDetails() {
        return this.stopDeploymentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public StopDeploymentDetails getBody$() {
        return this.stopDeploymentDetails;
    }

    public Builder toBuilder() {
        return new Builder().deploymentId(this.deploymentId).stopDeploymentDetails(this.stopDeploymentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",deploymentId=").append(String.valueOf(this.deploymentId));
        sb.append(",stopDeploymentDetails=").append(String.valueOf((Object)this.stopDeploymentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StopDeploymentRequest)) {
            return false;
        }
        StopDeploymentRequest other = (StopDeploymentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.deploymentId, other.deploymentId) && Objects.equals((Object)this.stopDeploymentDetails, (Object)other.stopDeploymentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.deploymentId == null ? 43 : this.deploymentId.hashCode());
        result = result * 59 + (this.stopDeploymentDetails == null ? 43 : this.stopDeploymentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<StopDeploymentRequest, StopDeploymentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String deploymentId = null;
        private StopDeploymentDetails stopDeploymentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public Builder stopDeploymentDetails(StopDeploymentDetails stopDeploymentDetails) {
            this.stopDeploymentDetails = stopDeploymentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(StopDeploymentRequest o) {
            this.deploymentId(o.getDeploymentId());
            this.stopDeploymentDetails(o.getStopDeploymentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public StopDeploymentRequest build() {
            StopDeploymentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(StopDeploymentDetails body) {
            this.stopDeploymentDetails(body);
            return this;
        }

        public StopDeploymentRequest buildWithoutInvocationCallback() {
            StopDeploymentRequest request = new StopDeploymentRequest();
            request.deploymentId = this.deploymentId;
            request.stopDeploymentDetails = this.stopDeploymentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

