/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDeploymentBackupRequest
extends BmcRequest<Void> {
    private String deploymentBackupId;
    private String opcRequestId;

    public String getDeploymentBackupId() {
        return this.deploymentBackupId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().deploymentBackupId(this.deploymentBackupId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",deploymentBackupId=").append(String.valueOf(this.deploymentBackupId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDeploymentBackupRequest)) {
            return false;
        }
        GetDeploymentBackupRequest other = (GetDeploymentBackupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.deploymentBackupId, other.deploymentBackupId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.deploymentBackupId == null ? 43 : this.deploymentBackupId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDeploymentBackupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String deploymentBackupId = null;
        private String opcRequestId = null;

        public Builder deploymentBackupId(String deploymentBackupId) {
            this.deploymentBackupId = deploymentBackupId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDeploymentBackupRequest o) {
            this.deploymentBackupId(o.getDeploymentBackupId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDeploymentBackupRequest build() {
            GetDeploymentBackupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDeploymentBackupRequest buildWithoutInvocationCallback() {
            GetDeploymentBackupRequest request = new GetDeploymentBackupRequest();
            request.deploymentBackupId = this.deploymentBackupId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

