/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.generativeaiinference.model.EmbedTextDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class EmbedTextRequest
extends BmcRequest<EmbedTextDetails> {
    private EmbedTextDetails embedTextDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public EmbedTextDetails getEmbedTextDetails() {
        return this.embedTextDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public EmbedTextDetails getBody$() {
        return this.embedTextDetails;
    }

    public Builder toBuilder() {
        return new Builder().embedTextDetails(this.embedTextDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",embedTextDetails=").append(String.valueOf((Object)this.embedTextDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmbedTextRequest)) {
            return false;
        }
        EmbedTextRequest other = (EmbedTextRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.embedTextDetails, (Object)other.embedTextDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.embedTextDetails == null ? 43 : this.embedTextDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<EmbedTextRequest, EmbedTextDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private EmbedTextDetails embedTextDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder embedTextDetails(EmbedTextDetails embedTextDetails) {
            this.embedTextDetails = embedTextDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(EmbedTextRequest o) {
            this.embedTextDetails(o.getEmbedTextDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public EmbedTextRequest build() {
            EmbedTextRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(EmbedTextDetails body) {
            this.embedTextDetails(body);
            return this;
        }

        public EmbedTextRequest buildWithoutInvocationCallback() {
            EmbedTextRequest request = new EmbedTextRequest();
            request.embedTextDetails = this.embedTextDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

