/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.Usage;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EmbedTextResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="inputs")
    private final List<String> inputs;
    @JsonProperty(value="embeddings")
    private final List<List<Float>> embeddings;
    @JsonProperty(value="modelId")
    private final String modelId;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="usage")
    private final Usage usage;

    @Deprecated
    @ConstructorProperties(value={"id", "inputs", "embeddings", "modelId", "modelVersion", "usage"})
    public EmbedTextResult(String id, List<String> inputs, List<List<Float>> embeddings, String modelId, String modelVersion, Usage usage) {
        this.id = id;
        this.inputs = inputs;
        this.embeddings = embeddings;
        this.modelId = modelId;
        this.modelVersion = modelVersion;
        this.usage = usage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public List<List<Float>> getEmbeddings() {
        return this.embeddings;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EmbedTextResult(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", inputs=").append(String.valueOf(this.inputs));
        sb.append(", embeddings=").append(String.valueOf(this.embeddings));
        sb.append(", modelId=").append(String.valueOf(this.modelId));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", usage=").append(String.valueOf((Object)this.usage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmbedTextResult)) {
            return false;
        }
        EmbedTextResult other = (EmbedTextResult)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.inputs, other.inputs) && Objects.equals(this.embeddings, other.embeddings) && Objects.equals(this.modelId, other.modelId) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.usage, (Object)other.usage) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.inputs == null ? 43 : this.inputs.hashCode());
        result = result * 59 + (this.embeddings == null ? 43 : this.embeddings.hashCode());
        result = result * 59 + (this.modelId == null ? 43 : this.modelId.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.usage == null ? 43 : this.usage.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="inputs")
        private List<String> inputs;
        @JsonProperty(value="embeddings")
        private List<List<Float>> embeddings;
        @JsonProperty(value="modelId")
        private String modelId;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="usage")
        private Usage usage;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder inputs(List<String> inputs) {
            this.inputs = inputs;
            this.__explicitlySet__.add("inputs");
            return this;
        }

        public Builder embeddings(List<List<Float>> embeddings) {
            this.embeddings = embeddings;
            this.__explicitlySet__.add("embeddings");
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            this.__explicitlySet__.add("modelId");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder usage(Usage usage) {
            this.usage = usage;
            this.__explicitlySet__.add("usage");
            return this;
        }

        public EmbedTextResult build() {
            EmbedTextResult model = new EmbedTextResult(this.id, this.inputs, this.embeddings, this.modelId, this.modelVersion, this.usage);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EmbedTextResult model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("inputs")) {
                this.inputs(model.getInputs());
            }
            if (model.wasPropertyExplicitlySet("embeddings")) {
                this.embeddings(model.getEmbeddings());
            }
            if (model.wasPropertyExplicitlySet("modelId")) {
                this.modelId(model.getModelId());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("usage")) {
                this.usage(model.getUsage());
            }
            return this;
        }
    }
}

