/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.CohereParameterDefinition;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CohereTool
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="parameterDefinitions")
    private final Map<String, CohereParameterDefinition> parameterDefinitions;

    @Deprecated
    @ConstructorProperties(value={"name", "description", "parameterDefinitions"})
    public CohereTool(String name, String description, Map<String, CohereParameterDefinition> parameterDefinitions) {
        this.name = name;
        this.description = description;
        this.parameterDefinitions = parameterDefinitions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, CohereParameterDefinition> getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CohereTool(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", parameterDefinitions=").append(String.valueOf(this.parameterDefinitions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CohereTool)) {
            return false;
        }
        CohereTool other = (CohereTool)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.parameterDefinitions, other.parameterDefinitions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.parameterDefinitions == null ? 43 : this.parameterDefinitions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="parameterDefinitions")
        private Map<String, CohereParameterDefinition> parameterDefinitions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder parameterDefinitions(Map<String, CohereParameterDefinition> parameterDefinitions) {
            this.parameterDefinitions = parameterDefinitions;
            this.__explicitlySet__.add("parameterDefinitions");
            return this;
        }

        public CohereTool build() {
            CohereTool model = new CohereTool(this.name, this.description, this.parameterDefinitions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CohereTool model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("parameterDefinitions")) {
                this.parameterDefinitions(model.getParameterDefinitions());
            }
            return this;
        }
    }
}

