/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.BaseChatRequest;
import com.oracle.bmc.generativeaiinference.model.ServingMode;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ChatDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="servingMode")
    private final ServingMode servingMode;
    @JsonProperty(value="chatRequest")
    private final BaseChatRequest chatRequest;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "servingMode", "chatRequest"})
    public ChatDetails(String compartmentId, ServingMode servingMode, BaseChatRequest chatRequest) {
        this.compartmentId = compartmentId;
        this.servingMode = servingMode;
        this.chatRequest = chatRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public ServingMode getServingMode() {
        return this.servingMode;
    }

    public BaseChatRequest getChatRequest() {
        return this.chatRequest;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ChatDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", servingMode=").append(String.valueOf((Object)this.servingMode));
        sb.append(", chatRequest=").append(String.valueOf((Object)this.chatRequest));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChatDetails)) {
            return false;
        }
        ChatDetails other = (ChatDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.servingMode, (Object)other.servingMode) && Objects.equals((Object)this.chatRequest, (Object)other.chatRequest) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.servingMode == null ? 43 : this.servingMode.hashCode());
        result = result * 59 + (this.chatRequest == null ? 43 : this.chatRequest.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="servingMode")
        private ServingMode servingMode;
        @JsonProperty(value="chatRequest")
        private BaseChatRequest chatRequest;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder servingMode(ServingMode servingMode) {
            this.servingMode = servingMode;
            this.__explicitlySet__.add("servingMode");
            return this;
        }

        public Builder chatRequest(BaseChatRequest chatRequest) {
            this.chatRequest = chatRequest;
            this.__explicitlySet__.add("chatRequest");
            return this;
        }

        public ChatDetails build() {
            ChatDetails model = new ChatDetails(this.compartmentId, this.servingMode, this.chatRequest);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ChatDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("servingMode")) {
                this.servingMode(model.getServingMode());
            }
            if (model.wasPropertyExplicitlySet("chatRequest")) {
                this.chatRequest(model.getChatRequest());
            }
            return this;
        }
    }
}

