/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.Annotation;
import com.oracle.bmc.generativeaiinference.model.ChatContent;
import com.oracle.bmc.generativeaiinference.model.Message;
import com.oracle.bmc.generativeaiinference.model.ToolCall;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="role")
@JsonFilter(value="explicitlySetFilter")
public final class AssistantMessage
extends Message {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="refusal")
    private final String refusal;
    @JsonProperty(value="toolCalls")
    private final List<ToolCall> toolCalls;
    @JsonProperty(value="annotations")
    private final List<Annotation> annotations;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public AssistantMessage(List<ChatContent> content, String name, String refusal, List<ToolCall> toolCalls, List<Annotation> annotations) {
        super(content);
        this.name = name;
        this.refusal = refusal;
        this.toolCalls = toolCalls;
        this.annotations = annotations;
    }

    public String getName() {
        return this.name;
    }

    public String getRefusal() {
        return this.refusal;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AssistantMessage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", refusal=").append(String.valueOf(this.refusal));
        sb.append(", toolCalls=").append(String.valueOf(this.toolCalls));
        sb.append(", annotations=").append(String.valueOf(this.annotations));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssistantMessage)) {
            return false;
        }
        AssistantMessage other = (AssistantMessage)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.refusal, other.refusal) && Objects.equals(this.toolCalls, other.toolCalls) && Objects.equals(this.annotations, other.annotations) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.refusal == null ? 43 : this.refusal.hashCode());
        result = result * 59 + (this.toolCalls == null ? 43 : this.toolCalls.hashCode());
        result = result * 59 + (this.annotations == null ? 43 : this.annotations.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="content")
        private List<ChatContent> content;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="refusal")
        private String refusal;
        @JsonProperty(value="toolCalls")
        private List<ToolCall> toolCalls;
        @JsonProperty(value="annotations")
        private List<Annotation> annotations;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder content(List<ChatContent> content) {
            this.content = content;
            this.__explicitlySet__.add("content");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder refusal(String refusal) {
            this.refusal = refusal;
            this.__explicitlySet__.add("refusal");
            return this;
        }

        public Builder toolCalls(List<ToolCall> toolCalls) {
            this.toolCalls = toolCalls;
            this.__explicitlySet__.add("toolCalls");
            return this;
        }

        public Builder annotations(List<Annotation> annotations) {
            this.annotations = annotations;
            this.__explicitlySet__.add("annotations");
            return this;
        }

        public AssistantMessage build() {
            AssistantMessage model = new AssistantMessage(this.content, this.name, this.refusal, this.toolCalls, this.annotations);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AssistantMessage model) {
            if (model.wasPropertyExplicitlySet("content")) {
                this.content(model.getContent());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("refusal")) {
                this.refusal(model.getRefusal());
            }
            if (model.wasPropertyExplicitlySet("toolCalls")) {
                this.toolCalls(model.getToolCalls());
            }
            if (model.wasPropertyExplicitlySet("annotations")) {
                this.annotations(model.getAnnotations());
            }
            return this;
        }
    }
}

