/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.generativeaiinference.GenerativeAiInference;
import com.oracle.bmc.generativeaiinference.model.ApplyGuardrailsResult;
import com.oracle.bmc.generativeaiinference.model.ChatResult;
import com.oracle.bmc.generativeaiinference.model.EmbedTextResult;
import com.oracle.bmc.generativeaiinference.model.GenerateTextResult;
import com.oracle.bmc.generativeaiinference.model.RerankTextResult;
import com.oracle.bmc.generativeaiinference.model.SummarizeTextResult;
import com.oracle.bmc.generativeaiinference.requests.ApplyGuardrailsRequest;
import com.oracle.bmc.generativeaiinference.requests.ChatRequest;
import com.oracle.bmc.generativeaiinference.requests.EmbedTextRequest;
import com.oracle.bmc.generativeaiinference.requests.GenerateTextRequest;
import com.oracle.bmc.generativeaiinference.requests.RerankTextRequest;
import com.oracle.bmc.generativeaiinference.requests.SummarizeTextRequest;
import com.oracle.bmc.generativeaiinference.responses.ApplyGuardrailsResponse;
import com.oracle.bmc.generativeaiinference.responses.ChatResponse;
import com.oracle.bmc.generativeaiinference.responses.EmbedTextResponse;
import com.oracle.bmc.generativeaiinference.responses.GenerateTextResponse;
import com.oracle.bmc.generativeaiinference.responses.RerankTextResponse;
import com.oracle.bmc.generativeaiinference.responses.SummarizeTextResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.util.CircuitBreakerUtils;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerativeAiInferenceClient
extends BaseSyncClient
implements GenerativeAiInference {
    public static final Service SERVICE = Services.serviceBuilder().serviceName(GenerativeAiInferenceClient.class.getName()).serviceEndpointPrefix("").serviceEndpointTemplate("https://inference.generativeai.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(GenerativeAiInferenceClient.class);

    GenerativeAiInferenceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ApplyGuardrailsResponse applyGuardrails(ApplyGuardrailsRequest request) {
        Objects.requireNonNull(request.getApplyGuardrailsDetails(), "applyGuardrailsDetails is required");
        return (ApplyGuardrailsResponse)this.clientCall(request, ApplyGuardrailsResponse::builder).logger(LOG, "applyGuardrails").serviceDetails("GenerativeAiInference", "ApplyGuardrails", "https://docs.oracle.com/iaas/api/#/en/generative-ai-inference/20231130/ApplyGuardrailsResult/ApplyGuardrails").method(Method.POST).requestBuilder(ApplyGuardrailsRequest::builder).basePath("/20231130").appendPathParam("actions").appendPathParam("applyGuardrails").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(ApplyGuardrailsResult.class, ApplyGuardrailsResponse.Builder::applyGuardrailsResult).handleResponseHeaderString("opc-request-id", ApplyGuardrailsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChatResponse chat(ChatRequest request) {
        Objects.requireNonNull(request.getChatDetails(), "chatDetails is required");
        return (ChatResponse)this.clientCall(request, ChatResponse::builder).logger(LOG, "chat").serviceDetails("GenerativeAiInference", "Chat", "https://docs.oracle.com/iaas/api/#/en/generative-ai-inference/20231130/ChatResult/Chat").method(Method.POST).requestBuilder(ChatRequest::builder).basePath("/20231130").appendPathParam("actions").appendPathParam("chat").accept(new String[]{"application/json, text/event-stream"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(ChatResult.class, ChatResponse.Builder::chatResult).handleEventStream(ChatResponse.Builder::eventStream).handleResponseHeaderString("etag", ChatResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChatResponse.Builder::opcRequestId).handleResponseHeaderString("model-deprecation-info", ChatResponse.Builder::modelDeprecationInfo).callSync();
    }

    @Override
    public EmbedTextResponse embedText(EmbedTextRequest request) {
        Objects.requireNonNull(request.getEmbedTextDetails(), "embedTextDetails is required");
        return (EmbedTextResponse)this.clientCall(request, EmbedTextResponse::builder).logger(LOG, "embedText").serviceDetails("GenerativeAiInference", "EmbedText", "https://docs.oracle.com/iaas/api/#/en/generative-ai-inference/20231130/EmbedTextResult/EmbedText").method(Method.POST).requestBuilder(EmbedTextRequest::builder).basePath("/20231130").appendPathParam("actions").appendPathParam("embedText").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(EmbedTextResult.class, EmbedTextResponse.Builder::embedTextResult).handleResponseHeaderString("etag", EmbedTextResponse.Builder::etag).handleResponseHeaderString("opc-request-id", EmbedTextResponse.Builder::opcRequestId).handleResponseHeaderString("model-deprecation-info", EmbedTextResponse.Builder::modelDeprecationInfo).callSync();
    }

    @Override
    public GenerateTextResponse generateText(GenerateTextRequest request) {
        Objects.requireNonNull(request.getGenerateTextDetails(), "generateTextDetails is required");
        return (GenerateTextResponse)this.clientCall(request, GenerateTextResponse::builder).logger(LOG, "generateText").serviceDetails("GenerativeAiInference", "GenerateText", "https://docs.oracle.com/iaas/api/#/en/generative-ai-inference/20231130/GenerateTextResult/GenerateText").method(Method.POST).requestBuilder(GenerateTextRequest::builder).basePath("/20231130").appendPathParam("actions").appendPathParam("generateText").accept(new String[]{"application/json, text/event-stream"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(GenerateTextResult.class, GenerateTextResponse.Builder::generateTextResult).handleEventStream(GenerateTextResponse.Builder::eventStream).handleResponseHeaderString("etag", GenerateTextResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GenerateTextResponse.Builder::opcRequestId).handleResponseHeaderString("model-deprecation-info", GenerateTextResponse.Builder::modelDeprecationInfo).callSync();
    }

    @Override
    public RerankTextResponse rerankText(RerankTextRequest request) {
        Objects.requireNonNull(request.getRerankTextDetails(), "rerankTextDetails is required");
        return (RerankTextResponse)this.clientCall(request, RerankTextResponse::builder).logger(LOG, "rerankText").serviceDetails("GenerativeAiInference", "RerankText", "https://docs.oracle.com/iaas/api/#/en/generative-ai-inference/20231130/RerankTextResult/RerankText").method(Method.POST).requestBuilder(RerankTextRequest::builder).basePath("/20231130").appendPathParam("actions").appendPathParam("rerankText").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(RerankTextResult.class, RerankTextResponse.Builder::rerankTextResult).handleResponseHeaderString("etag", RerankTextResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RerankTextResponse.Builder::opcRequestId).handleResponseHeaderString("model-deprecation-info", RerankTextResponse.Builder::modelDeprecationInfo).callSync();
    }

    @Override
    public SummarizeTextResponse summarizeText(SummarizeTextRequest request) {
        Objects.requireNonNull(request.getSummarizeTextDetails(), "summarizeTextDetails is required");
        return (SummarizeTextResponse)this.clientCall(request, SummarizeTextResponse::builder).logger(LOG, "summarizeText").serviceDetails("GenerativeAiInference", "SummarizeText", "https://docs.oracle.com/iaas/api/#/en/generative-ai-inference/20231130/SummarizeTextResult/SummarizeText").method(Method.POST).requestBuilder(SummarizeTextRequest::builder).basePath("/20231130").appendPathParam("actions").appendPathParam("summarizeText").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(SummarizeTextResult.class, SummarizeTextResponse.Builder::summarizeTextResult).handleResponseHeaderString("etag", SummarizeTextResponse.Builder::etag).handleResponseHeaderString("opc-request-id", SummarizeTextResponse.Builder::opcRequestId).handleResponseHeaderString("model-deprecation-info", SummarizeTextResponse.Builder::modelDeprecationInfo).callSync();
    }

    @Deprecated
    public GenerativeAiInferenceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)GenerativeAiInferenceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiInferenceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(GenerativeAiInferenceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiInferenceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)GenerativeAiInferenceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiInferenceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)GenerativeAiInferenceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiInferenceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)GenerativeAiInferenceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiInferenceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)GenerativeAiInferenceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public GenerativeAiInferenceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)GenerativeAiInferenceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, GenerativeAiInferenceClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "generativeaiinference";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"generativeaiinference");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public GenerativeAiInferenceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new GenerativeAiInferenceClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

