/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.generativeaiinference.model.CohereMessage;
import com.oracle.bmc.generativeaiinference.model.CohereToolCall;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="role")
@JsonFilter(value="explicitlySetFilter")
public final class CohereChatBotMessage
extends CohereMessage {
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="toolCalls")
    private final List<CohereToolCall> toolCalls;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CohereChatBotMessage(String message, List<CohereToolCall> toolCalls) {
        this.message = message;
        this.toolCalls = toolCalls;
    }

    public String getMessage() {
        return this.message;
    }

    public List<CohereToolCall> getToolCalls() {
        return this.toolCalls;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CohereChatBotMessage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", message=").append(String.valueOf(this.message));
        sb.append(", toolCalls=").append(String.valueOf(this.toolCalls));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CohereChatBotMessage)) {
            return false;
        }
        CohereChatBotMessage other = (CohereChatBotMessage)((Object)o);
        return Objects.equals(this.message, other.message) && Objects.equals(this.toolCalls, other.toolCalls) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + (this.toolCalls == null ? 43 : this.toolCalls.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="toolCalls")
        private List<CohereToolCall> toolCalls;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public Builder toolCalls(List<CohereToolCall> toolCalls) {
            this.toolCalls = toolCalls;
            this.__explicitlySet__.add("toolCalls");
            return this;
        }

        public CohereChatBotMessage build() {
            CohereChatBotMessage model = new CohereChatBotMessage(this.message, this.toolCalls);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CohereChatBotMessage model) {
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            if (model.wasPropertyExplicitlySet("toolCalls")) {
                this.toolCalls(model.getToolCalls());
            }
            return this;
        }
    }
}

