/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.fusionapps.model.ScheduledActivity;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListScheduledActivitiesRequest
extends BmcRequest<Void> {
    private String fusionEnvironmentId;
    private String displayName;
    private Date timeScheduledStartGreaterThanOrEqualTo;
    private Date timeExpectedFinishLessThanOrEqualTo;
    private ScheduledActivity.RunCycle runCycle;
    private ScheduledActivity.LifecycleState lifecycleState;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getFusionEnvironmentId() {
        return this.fusionEnvironmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getTimeScheduledStartGreaterThanOrEqualTo() {
        return this.timeScheduledStartGreaterThanOrEqualTo;
    }

    public Date getTimeExpectedFinishLessThanOrEqualTo() {
        return this.timeExpectedFinishLessThanOrEqualTo;
    }

    public ScheduledActivity.RunCycle getRunCycle() {
        return this.runCycle;
    }

    public ScheduledActivity.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().fusionEnvironmentId(this.fusionEnvironmentId).displayName(this.displayName).timeScheduledStartGreaterThanOrEqualTo(this.timeScheduledStartGreaterThanOrEqualTo).timeExpectedFinishLessThanOrEqualTo(this.timeExpectedFinishLessThanOrEqualTo).runCycle(this.runCycle).lifecycleState(this.lifecycleState).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fusionEnvironmentId=").append(String.valueOf(this.fusionEnvironmentId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",timeScheduledStartGreaterThanOrEqualTo=").append(String.valueOf(this.timeScheduledStartGreaterThanOrEqualTo));
        sb.append(",timeExpectedFinishLessThanOrEqualTo=").append(String.valueOf(this.timeExpectedFinishLessThanOrEqualTo));
        sb.append(",runCycle=").append(String.valueOf((Object)this.runCycle));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListScheduledActivitiesRequest)) {
            return false;
        }
        ListScheduledActivitiesRequest other = (ListScheduledActivitiesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fusionEnvironmentId, other.fusionEnvironmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.timeScheduledStartGreaterThanOrEqualTo, other.timeScheduledStartGreaterThanOrEqualTo) && Objects.equals(this.timeExpectedFinishLessThanOrEqualTo, other.timeExpectedFinishLessThanOrEqualTo) && Objects.equals((Object)this.runCycle, (Object)other.runCycle) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fusionEnvironmentId == null ? 43 : this.fusionEnvironmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.timeScheduledStartGreaterThanOrEqualTo == null ? 43 : this.timeScheduledStartGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeExpectedFinishLessThanOrEqualTo == null ? 43 : this.timeExpectedFinishLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.runCycle == null ? 43 : this.runCycle.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListScheduledActivitiesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fusionEnvironmentId = null;
        private String displayName = null;
        private Date timeScheduledStartGreaterThanOrEqualTo = null;
        private Date timeExpectedFinishLessThanOrEqualTo = null;
        private ScheduledActivity.RunCycle runCycle = null;
        private ScheduledActivity.LifecycleState lifecycleState = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder fusionEnvironmentId(String fusionEnvironmentId) {
            this.fusionEnvironmentId = fusionEnvironmentId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder timeScheduledStartGreaterThanOrEqualTo(Date timeScheduledStartGreaterThanOrEqualTo) {
            this.timeScheduledStartGreaterThanOrEqualTo = timeScheduledStartGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeExpectedFinishLessThanOrEqualTo(Date timeExpectedFinishLessThanOrEqualTo) {
            this.timeExpectedFinishLessThanOrEqualTo = timeExpectedFinishLessThanOrEqualTo;
            return this;
        }

        public Builder runCycle(ScheduledActivity.RunCycle runCycle) {
            this.runCycle = runCycle;
            return this;
        }

        public Builder lifecycleState(ScheduledActivity.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListScheduledActivitiesRequest o) {
            this.fusionEnvironmentId(o.getFusionEnvironmentId());
            this.displayName(o.getDisplayName());
            this.timeScheduledStartGreaterThanOrEqualTo(o.getTimeScheduledStartGreaterThanOrEqualTo());
            this.timeExpectedFinishLessThanOrEqualTo(o.getTimeExpectedFinishLessThanOrEqualTo());
            this.runCycle(o.getRunCycle());
            this.lifecycleState(o.getLifecycleState());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListScheduledActivitiesRequest build() {
            ListScheduledActivitiesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListScheduledActivitiesRequest buildWithoutInvocationCallback() {
            ListScheduledActivitiesRequest request = new ListScheduledActivitiesRequest();
            request.fusionEnvironmentId = this.fusionEnvironmentId;
            request.displayName = this.displayName;
            request.timeScheduledStartGreaterThanOrEqualTo = this.timeScheduledStartGreaterThanOrEqualTo;
            request.timeExpectedFinishLessThanOrEqualTo = this.timeExpectedFinishLessThanOrEqualTo;
            request.runCycle = this.runCycle;
            request.lifecycleState = this.lifecycleState;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("TIME_CREATED"),
        DisplayName("DISPLAY_NAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

