/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.fusionapps.model.CreateRefreshActivityDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateRefreshActivityRequest
extends BmcRequest<CreateRefreshActivityDetails> {
    private String fusionEnvironmentId;
    private CreateRefreshActivityDetails createRefreshActivityDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getFusionEnvironmentId() {
        return this.fusionEnvironmentId;
    }

    public CreateRefreshActivityDetails getCreateRefreshActivityDetails() {
        return this.createRefreshActivityDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateRefreshActivityDetails getBody$() {
        return this.createRefreshActivityDetails;
    }

    public Builder toBuilder() {
        return new Builder().fusionEnvironmentId(this.fusionEnvironmentId).createRefreshActivityDetails(this.createRefreshActivityDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fusionEnvironmentId=").append(String.valueOf(this.fusionEnvironmentId));
        sb.append(",createRefreshActivityDetails=").append(String.valueOf((Object)this.createRefreshActivityDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateRefreshActivityRequest)) {
            return false;
        }
        CreateRefreshActivityRequest other = (CreateRefreshActivityRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fusionEnvironmentId, other.fusionEnvironmentId) && Objects.equals((Object)this.createRefreshActivityDetails, (Object)other.createRefreshActivityDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fusionEnvironmentId == null ? 43 : this.fusionEnvironmentId.hashCode());
        result = result * 59 + (this.createRefreshActivityDetails == null ? 43 : this.createRefreshActivityDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateRefreshActivityRequest, CreateRefreshActivityDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fusionEnvironmentId = null;
        private CreateRefreshActivityDetails createRefreshActivityDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder fusionEnvironmentId(String fusionEnvironmentId) {
            this.fusionEnvironmentId = fusionEnvironmentId;
            return this;
        }

        public Builder createRefreshActivityDetails(CreateRefreshActivityDetails createRefreshActivityDetails) {
            this.createRefreshActivityDetails = createRefreshActivityDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateRefreshActivityRequest o) {
            this.fusionEnvironmentId(o.getFusionEnvironmentId());
            this.createRefreshActivityDetails(o.getCreateRefreshActivityDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateRefreshActivityRequest build() {
            CreateRefreshActivityRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateRefreshActivityDetails body) {
            this.createRefreshActivityDetails(body);
            return this;
        }

        public CreateRefreshActivityRequest buildWithoutInvocationCallback() {
            CreateRefreshActivityRequest request = new CreateRefreshActivityRequest();
            request.fusionEnvironmentId = this.fusionEnvironmentId;
            request.createRefreshActivityDetails = this.createRefreshActivityDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

