/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.fusionapps.model.Action;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="actionType")
@JsonFilter(value="explicitlySetFilter")
public final class VertexAction
extends Action {
    @JsonProperty(value="artifact")
    private final String artifact;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public VertexAction(String referenceKey, Action.State state, String description, String artifact) {
        super(referenceKey, state, description);
        this.artifact = artifact;
    }

    public String getArtifact() {
        return this.artifact;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VertexAction(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", artifact=").append(String.valueOf(this.artifact));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VertexAction)) {
            return false;
        }
        VertexAction other = (VertexAction)((Object)o);
        return Objects.equals(this.artifact, other.artifact) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.artifact == null ? 43 : this.artifact.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="referenceKey")
        private String referenceKey;
        @JsonProperty(value="state")
        private Action.State state;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="artifact")
        private String artifact;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder referenceKey(String referenceKey) {
            this.referenceKey = referenceKey;
            this.__explicitlySet__.add("referenceKey");
            return this;
        }

        public Builder state(Action.State state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder artifact(String artifact) {
            this.artifact = artifact;
            this.__explicitlySet__.add("artifact");
            return this;
        }

        public VertexAction build() {
            VertexAction model = new VertexAction(this.referenceKey, this.state, this.description, this.artifact);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VertexAction model) {
            if (model.wasPropertyExplicitlySet("referenceKey")) {
                this.referenceKey(model.getReferenceKey());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("artifact")) {
                this.artifact(model.getArtifact());
            }
            return this;
        }
    }
}

