/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SubscriptionSku
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sku")
    private final String sku;
    @JsonProperty(value="licensePartDescription")
    private final String licensePartDescription;
    @JsonProperty(value="metricName")
    private final String metricName;
    @JsonProperty(value="quantity")
    private final Integer quantity;
    @JsonProperty(value="description")
    private final String description;

    @Deprecated
    @ConstructorProperties(value={"sku", "licensePartDescription", "metricName", "quantity", "description"})
    public SubscriptionSku(String sku, String licensePartDescription, String metricName, Integer quantity, String description) {
        this.sku = sku;
        this.licensePartDescription = licensePartDescription;
        this.metricName = metricName;
        this.quantity = quantity;
        this.description = description;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSku() {
        return this.sku;
    }

    public String getLicensePartDescription() {
        return this.licensePartDescription;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SubscriptionSku(");
        sb.append("super=").append(super.toString());
        sb.append("sku=").append(String.valueOf(this.sku));
        sb.append(", licensePartDescription=").append(String.valueOf(this.licensePartDescription));
        sb.append(", metricName=").append(String.valueOf(this.metricName));
        sb.append(", quantity=").append(String.valueOf(this.quantity));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscriptionSku)) {
            return false;
        }
        SubscriptionSku other = (SubscriptionSku)((Object)o);
        return Objects.equals(this.sku, other.sku) && Objects.equals(this.licensePartDescription, other.licensePartDescription) && Objects.equals(this.metricName, other.metricName) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.description, other.description) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sku == null ? 43 : this.sku.hashCode());
        result = result * 59 + (this.licensePartDescription == null ? 43 : this.licensePartDescription.hashCode());
        result = result * 59 + (this.metricName == null ? 43 : this.metricName.hashCode());
        result = result * 59 + (this.quantity == null ? 43 : this.quantity.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sku")
        private String sku;
        @JsonProperty(value="licensePartDescription")
        private String licensePartDescription;
        @JsonProperty(value="metricName")
        private String metricName;
        @JsonProperty(value="quantity")
        private Integer quantity;
        @JsonProperty(value="description")
        private String description;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sku(String sku) {
            this.sku = sku;
            this.__explicitlySet__.add("sku");
            return this;
        }

        public Builder licensePartDescription(String licensePartDescription) {
            this.licensePartDescription = licensePartDescription;
            this.__explicitlySet__.add("licensePartDescription");
            return this;
        }

        public Builder metricName(String metricName) {
            this.metricName = metricName;
            this.__explicitlySet__.add("metricName");
            return this;
        }

        public Builder quantity(Integer quantity) {
            this.quantity = quantity;
            this.__explicitlySet__.add("quantity");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public SubscriptionSku build() {
            SubscriptionSku model = new SubscriptionSku(this.sku, this.licensePartDescription, this.metricName, this.quantity, this.description);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SubscriptionSku model) {
            if (model.wasPropertyExplicitlySet("sku")) {
                this.sku(model.getSku());
            }
            if (model.wasPropertyExplicitlySet("licensePartDescription")) {
                this.licensePartDescription(model.getLicensePartDescription());
            }
            if (model.wasPropertyExplicitlySet("metricName")) {
                this.metricName(model.getMetricName());
            }
            if (model.wasPropertyExplicitlySet("quantity")) {
                this.quantity(model.getQuantity());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            return this;
        }
    }
}

