/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataMaskingActivity
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="fusionEnvironmentId")
    private final String fusionEnvironmentId;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeMaskingStart")
    private final Date timeMaskingStart;
    @JsonProperty(value="timeMaskingFinish")
    private final Date timeMaskingFinish;

    @Deprecated
    @ConstructorProperties(value={"id", "fusionEnvironmentId", "lifecycleState", "timeMaskingStart", "timeMaskingFinish"})
    public DataMaskingActivity(String id, String fusionEnvironmentId, LifecycleState lifecycleState, Date timeMaskingStart, Date timeMaskingFinish) {
        this.id = id;
        this.fusionEnvironmentId = fusionEnvironmentId;
        this.lifecycleState = lifecycleState;
        this.timeMaskingStart = timeMaskingStart;
        this.timeMaskingFinish = timeMaskingFinish;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getFusionEnvironmentId() {
        return this.fusionEnvironmentId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeMaskingStart() {
        return this.timeMaskingStart;
    }

    public Date getTimeMaskingFinish() {
        return this.timeMaskingFinish;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataMaskingActivity(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", fusionEnvironmentId=").append(String.valueOf(this.fusionEnvironmentId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeMaskingStart=").append(String.valueOf(this.timeMaskingStart));
        sb.append(", timeMaskingFinish=").append(String.valueOf(this.timeMaskingFinish));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataMaskingActivity)) {
            return false;
        }
        DataMaskingActivity other = (DataMaskingActivity)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.fusionEnvironmentId, other.fusionEnvironmentId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeMaskingStart, other.timeMaskingStart) && Objects.equals(this.timeMaskingFinish, other.timeMaskingFinish) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.fusionEnvironmentId == null ? 43 : this.fusionEnvironmentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeMaskingStart == null ? 43 : this.timeMaskingStart.hashCode());
        result = result * 59 + (this.timeMaskingFinish == null ? 43 : this.timeMaskingFinish.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Accepted("ACCEPTED"),
        InProgress("IN_PROGRESS"),
        Failed("FAILED"),
        Succeeded("SUCCEEDED"),
        Canceled("CANCELED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="fusionEnvironmentId")
        private String fusionEnvironmentId;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeMaskingStart")
        private Date timeMaskingStart;
        @JsonProperty(value="timeMaskingFinish")
        private Date timeMaskingFinish;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder fusionEnvironmentId(String fusionEnvironmentId) {
            this.fusionEnvironmentId = fusionEnvironmentId;
            this.__explicitlySet__.add("fusionEnvironmentId");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeMaskingStart(Date timeMaskingStart) {
            this.timeMaskingStart = timeMaskingStart;
            this.__explicitlySet__.add("timeMaskingStart");
            return this;
        }

        public Builder timeMaskingFinish(Date timeMaskingFinish) {
            this.timeMaskingFinish = timeMaskingFinish;
            this.__explicitlySet__.add("timeMaskingFinish");
            return this;
        }

        public DataMaskingActivity build() {
            DataMaskingActivity model = new DataMaskingActivity(this.id, this.fusionEnvironmentId, this.lifecycleState, this.timeMaskingStart, this.timeMaskingFinish);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataMaskingActivity model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("fusionEnvironmentId")) {
                this.fusionEnvironmentId(model.getFusionEnvironmentId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeMaskingStart")) {
                this.timeMaskingStart(model.getTimeMaskingStart());
            }
            if (model.wasPropertyExplicitlySet("timeMaskingFinish")) {
                this.timeMaskingFinish(model.getTimeMaskingFinish());
            }
            return this;
        }
    }
}

