/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.fusionapps.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.fusionapps.model.PatchAction;
import com.oracle.bmc.fusionapps.model.UpgradeAction;
import com.oracle.bmc.fusionapps.model.VertexAction;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="actionType", defaultImpl=Action.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=PatchAction.class, name="PATCH"), @JsonSubTypes.Type(value=UpgradeAction.class, name="QUARTERLY_UPGRADE"), @JsonSubTypes.Type(value=VertexAction.class, name="VERTEX")})
@JsonFilter(value="explicitlySetFilter")
public class Action
extends ExplicitlySetBmcModel {
    @JsonProperty(value="referenceKey")
    private final String referenceKey;
    @JsonProperty(value="state")
    private final State state;
    @JsonProperty(value="description")
    private final String description;

    @Deprecated
    @ConstructorProperties(value={"referenceKey", "state", "description"})
    protected Action(String referenceKey, State state, String description) {
        this.referenceKey = referenceKey;
        this.state = state;
        this.description = description;
    }

    public String getReferenceKey() {
        return this.referenceKey;
    }

    public State getState() {
        return this.state;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Action(");
        sb.append("super=").append(super.toString());
        sb.append("referenceKey=").append(String.valueOf(this.referenceKey));
        sb.append(", state=").append(String.valueOf((Object)this.state));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action other = (Action)((Object)o);
        return Objects.equals(this.referenceKey, other.referenceKey) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.description, other.description) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.referenceKey == null ? 43 : this.referenceKey.hashCode());
        result = result * 59 + (this.state == null ? 43 : this.state.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ActionType implements BmcEnum
    {
        QuarterlyUpgrade("QUARTERLY_UPGRADE"),
        Patch("PATCH"),
        Vertex("VERTEX"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ActionType> map;

        private ActionType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ActionType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ActionType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ActionType.class);
            map = new HashMap<String, ActionType>();
            for (ActionType v : ActionType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum State implements BmcEnum
    {
        Accepted("ACCEPTED"),
        InProgress("IN_PROGRESS"),
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        Canceled("CANCELED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, State> map;

        private State(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static State create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'State', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(State.class);
            map = new HashMap<String, State>();
            for (State v : State.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

