/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions;

import com.oracle.bmc.functions.FunctionsManagement;
import com.oracle.bmc.functions.model.Application;
import com.oracle.bmc.functions.model.Function;
import com.oracle.bmc.functions.requests.GetApplicationRequest;
import com.oracle.bmc.functions.requests.GetFunctionRequest;
import com.oracle.bmc.functions.responses.GetApplicationResponse;
import com.oracle.bmc.functions.responses.GetFunctionResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class FunctionsManagementWaiters {
    private final ExecutorService executorService;
    private final FunctionsManagement client;

    public FunctionsManagementWaiters(ExecutorService executorService, FunctionsManagement client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetApplicationRequest, GetApplicationResponse> forApplication(GetApplicationRequest request, Application.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forApplication(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetApplicationRequest, GetApplicationResponse> forApplication(GetApplicationRequest request, Application.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forApplication(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetApplicationRequest, GetApplicationResponse> forApplication(GetApplicationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Application.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forApplication(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetApplicationRequest, GetApplicationResponse> forApplication(BmcGenericWaiter waiter, GetApplicationRequest request, Application.LifecycleState ... targetStates) {
        final HashSet<Application.LifecycleState> targetStatesSet = new HashSet<Application.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetApplicationRequest, GetApplicationResponse>(){

            @Override
            public GetApplicationResponse apply(GetApplicationRequest request) {
                return FunctionsManagementWaiters.this.client.getApplication(request);
            }
        }, (Predicate)new Predicate<GetApplicationResponse>(){

            @Override
            public boolean test(GetApplicationResponse response) {
                return targetStatesSet.contains((Object)response.getApplication().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Application.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetFunctionRequest, GetFunctionResponse> forFunction(GetFunctionRequest request, Function.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forFunction(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetFunctionRequest, GetFunctionResponse> forFunction(GetFunctionRequest request, Function.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forFunction(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetFunctionRequest, GetFunctionResponse> forFunction(GetFunctionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Function.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forFunction(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetFunctionRequest, GetFunctionResponse> forFunction(BmcGenericWaiter waiter, GetFunctionRequest request, Function.LifecycleState ... targetStates) {
        final HashSet<Function.LifecycleState> targetStatesSet = new HashSet<Function.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetFunctionRequest, GetFunctionResponse>(){

            @Override
            public GetFunctionResponse apply(GetFunctionRequest request) {
                return FunctionsManagementWaiters.this.client.getFunction(request);
            }
        }, (Predicate)new Predicate<GetFunctionResponse>(){

            @Override
            public boolean test(GetFunctionResponse response) {
                return targetStatesSet.contains((Object)response.getFunction().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Function.LifecycleState.Deleted)), (Object)request);
    }
}

