/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.events.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.events.model.Action;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="actionType")
@JsonFilter(value="explicitlySetFilter")
public final class StreamingServiceAction
extends Action {
    @JsonProperty(value="streamId")
    private final String streamId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public StreamingServiceAction(String id, String lifecycleMessage, Action.LifecycleState lifecycleState, Boolean isEnabled, String description, String streamId) {
        super(id, lifecycleMessage, lifecycleState, isEnabled, description);
        this.streamId = streamId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StreamingServiceAction(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", streamId=").append(String.valueOf(this.streamId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamingServiceAction)) {
            return false;
        }
        StreamingServiceAction other = (StreamingServiceAction)((Object)o);
        return Objects.equals(this.streamId, other.streamId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamId == null ? 43 : this.streamId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="lifecycleMessage")
        private String lifecycleMessage;
        @JsonProperty(value="lifecycleState")
        private Action.LifecycleState lifecycleState;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="streamId")
        private String streamId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder lifecycleMessage(String lifecycleMessage) {
            this.lifecycleMessage = lifecycleMessage;
            this.__explicitlySet__.add("lifecycleMessage");
            return this;
        }

        public Builder lifecycleState(Action.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            this.__explicitlySet__.add("streamId");
            return this;
        }

        public StreamingServiceAction build() {
            StreamingServiceAction model = new StreamingServiceAction(this.id, this.lifecycleMessage, this.lifecycleState, this.isEnabled, this.description, this.streamId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StreamingServiceAction model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleMessage")) {
                this.lifecycleMessage(model.getLifecycleMessage());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("streamId")) {
                this.streamId(model.getStreamId());
            }
            return this;
        }
    }
}

