/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.encryption.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.bmc.encryption.KmsMasterKey;
import com.oracle.bmc.encryption.MasterKeyProvider;
import com.oracle.bmc.encryption.internal.DataKey;
import com.oracle.bmc.encryption.internal.EncryptionHeader;
import com.oracle.bmc.encryption.internal.EncryptionKey;
import com.oracle.bmc.http.client.Serialization;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;

public class SerializeHeader {
    private final MasterKeyProvider provider;
    private static final int INITIAL_OFFSET = 6;
    private static final short VERSION = 1;
    private static final ObjectMapper OBJECT_MAPPER = Serialization.getObjectMapper();

    public SerializeHeader(MasterKeyProvider provider) {
        this.provider = provider;
    }

    public EncryptionHeader createHeader(DataKey dataKey, byte[] IVbytes, Map<String, String> context) {
        EncryptionHeader encryptionHeader = this.createEncryptionHeader(dataKey, IVbytes, context);
        String jsonHeader = this.serializeJsonHeader(encryptionHeader);
        int headerLength = jsonHeader.getBytes().length;
        ByteBuffer buffer = ByteBuffer.allocate(6 + headerLength);
        buffer.putShort((short)1);
        buffer.putInt(headerLength);
        buffer.put(jsonHeader.getBytes());
        byte[] headerBytes = buffer.array();
        encryptionHeader.setHeaderBytes(headerBytes);
        return encryptionHeader;
    }

    private EncryptionHeader createEncryptionHeader(DataKey dataKey, byte[] ivBytes, Map<String, String> context) {
        EncryptionHeader encryptionHeader = new EncryptionHeader();
        KmsMasterKey kmsMasterKey = (KmsMasterKey)this.provider.getMasterKey();
        EncryptionKey encryptionKey = new EncryptionKey(kmsMasterKey.getRegion(), kmsMasterKey.getVaultId(), kmsMasterKey.getKmsMasterKeyId(), dataKey.getCiphertext());
        String contextString = SerializeHeader.mapToJson(context);
        encryptionHeader.setEncryptionHeader(encryptionKey, Base64.getEncoder().encodeToString(ivBytes), contextString);
        return encryptionHeader;
    }

    static String mapToJson(Map<String, ?> context) {
        String contextString = "";
        if (context != null) {
            try {
                contextString = OBJECT_MAPPER.writeValueAsString(context);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Failed to parse encryption header. ", e);
            }
        }
        return contextString;
    }

    private String serializeJsonHeader(EncryptionHeader encryptionHeader) {
        String jsonOutput = null;
        ObjectMapper objectMapper = Serialization.getObjectMapper();
        try {
            jsonOutput = objectMapper.writeValueAsString((Object)encryptionHeader);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to parse encryption header. ", e);
        }
        return jsonOutput;
    }

    public EncryptionHeader deserializeJsonHeader(byte[] header) {
        EncryptionHeader encryptionHeader;
        ObjectMapper objectMapper = Serialization.getObjectMapper();
        try {
            encryptionHeader = (EncryptionHeader)objectMapper.readValue(header, EncryptionHeader.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse encryption header.", e);
        }
        return encryptionHeader;
    }

    public EncryptionHeader readHeader(InputStream decryptInputStream) throws IOException {
        byte[] readHeaderIntroBytes = new byte[6];
        this.readBytesFromStream(decryptInputStream, readHeaderIntroBytes);
        int jsonHeaderSize = this.getHeaderSize(readHeaderIntroBytes);
        byte[] jsonHeaderBytes = new byte[jsonHeaderSize];
        this.readBytesFromStream(decryptInputStream, jsonHeaderBytes);
        return this.deserializeJsonHeader(jsonHeaderBytes);
    }

    public int getHeaderSize(byte[] data) {
        ByteBuffer introHeader = ByteBuffer.wrap(data);
        short version = introHeader.getShort();
        if (version != 1) {
            throw new RuntimeException("Encryption header from the encrypted file (" + version + ") doesn't match expected version (" + 1 + "). Check if this encrypted file has the correct format.");
        }
        int size = introHeader.getInt();
        if (size <= 0) {
            throw new RuntimeException("Failed to read a valid encryption header size. Check if this encrypted file has the correct format.");
        }
        return size;
    }

    private int readBytesFromStream(InputStream decryptInputStream, byte[] readBytes) throws IOException {
        int readResult = decryptInputStream.read(readBytes);
        if (readResult <= 0) {
            throw new RuntimeException("Failed to read header from stream. Reached end of stream.");
        }
        return readResult;
    }
}

