/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.encryption.internal;

import com.oracle.bmc.auth.internal.AuthUtils;
import com.oracle.bmc.encryption.MasterKeyProvider;
import com.oracle.bmc.encryption.OciCryptoInputStream;
import com.oracle.bmc.encryption.OciCryptoResult;
import com.oracle.bmc.encryption.internal.CipherHandler;
import com.oracle.bmc.encryption.internal.DataKey;
import com.oracle.bmc.encryption.internal.EncryptionHeader;
import com.oracle.bmc.encryption.internal.EncryptionStream;
import com.oracle.bmc.encryption.internal.SerializeHeader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionHandler
extends CipherHandler {
    private final SerializeHeader serializeHeader;

    public EncryptionHandler(MasterKeyProvider provider) {
        super(provider);
        if (provider.getMasterKey() == null) {
            throw new IllegalArgumentException("Encryption Key info is missing in KmsMasterKey. Provide the vaultID and masterKeyID in KmsMasterKey.");
        }
        this.serializeHeader = new SerializeHeader(provider);
    }

    private SecretKeySpec generateSecretKeySpec(DataKey dataKey) {
        byte[] secretKeyBytes = AuthUtils.base64Decode((String)dataKey.getPlaintext());
        return new SecretKeySpec(secretKeyBytes, this.provider.getCryptoAlgorithm().getAlgorithm());
    }

    public CipherHandler.WithEncryptionHeader<OciCryptoInputStream> getEncryptInputStream(InputStream inputStream, Map<String, String> context) {
        DataKey dataKey = super.generateDataKey();
        EncryptionHeader encryptionHeader = this.serializeHeader.createHeader(dataKey, super.generateIV(), context);
        Cipher cipher = this.initCipher(1, this.generateSecretKeySpec(dataKey), encryptionHeader);
        return new CipherHandler.WithEncryptionHeader<OciCryptoInputStream>(new EncryptionStream(inputStream, cipher, encryptionHeader), encryptionHeader);
    }

    public OciCryptoResult encrypt(byte[] data, Map<String, String> context) throws IOException {
        DataKey dataKey = super.generateDataKey();
        EncryptionHeader encryptionHeader = this.serializeHeader.createHeader(dataKey, super.generateIV(), context);
        Cipher cipher = this.initCipher(1, this.generateSecretKeySpec(dataKey), encryptionHeader);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(encryptionHeader.getHeaderBytes());
        try {
            outputStream.write(cipher.doFinal(data));
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        return new OciCryptoResult(outputStream.toByteArray(), encryptionHeader);
    }
}

