/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.encryption;

import com.oracle.bmc.encryption.MasterKeyProvider;
import com.oracle.bmc.encryption.OciCryptoInputStream;
import com.oracle.bmc.encryption.OciCryptoResult;
import com.oracle.bmc.encryption.internal.DecryptionHandler;
import com.oracle.bmc.encryption.internal.EncryptionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public final class OciCrypto {
    public OciCryptoInputStream createEncryptingStream(MasterKeyProvider masterKeyProvider, InputStream inputStream) {
        return this.createEncryptingStream(masterKeyProvider, inputStream, null);
    }

    public OciCryptoInputStream createEncryptingStream(MasterKeyProvider masterKeyProvider, InputStream inputStream, Map<String, String> context) {
        EncryptionHandler crypto = new EncryptionHandler(masterKeyProvider);
        return crypto.getEncryptInputStream(inputStream, context).getResult();
    }

    public OciCryptoInputStream createDecryptingStream(MasterKeyProvider masterKeyProvider, InputStream inputStream) throws IOException {
        DecryptionHandler crypto = new DecryptionHandler(masterKeyProvider);
        return crypto.getDecryptInputStream(inputStream).getResult();
    }

    public OciCryptoResult encryptData(MasterKeyProvider masterKeyProvider, byte[] data) throws IOException {
        return this.encryptData(masterKeyProvider, data, null);
    }

    public OciCryptoResult encryptData(MasterKeyProvider masterKeyProvider, byte[] data, Map<String, String> context) throws IOException {
        EncryptionHandler crypto = new EncryptionHandler(masterKeyProvider);
        return crypto.encrypt(data, context);
    }

    public OciCryptoResult decryptData(MasterKeyProvider masterKeyProvider, byte[] data) throws IOException {
        DecryptionHandler crypto = new DecryptionHandler(masterKeyProvider);
        return crypto.decrypt(data);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OciCrypto)) {
            return false;
        }
        OciCrypto other = (OciCrypto)o;
        return true;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "OciCrypto()";
    }
}

