/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.emwarehouse;

import com.oracle.bmc.emwarehouse.EmWarehouse;
import com.oracle.bmc.emwarehouse.model.EmWarehouseSummary;
import com.oracle.bmc.emwarehouse.model.EtlRunSummary;
import com.oracle.bmc.emwarehouse.model.WorkRequestError;
import com.oracle.bmc.emwarehouse.model.WorkRequestLogEntry;
import com.oracle.bmc.emwarehouse.model.WorkRequestSummary;
import com.oracle.bmc.emwarehouse.requests.ListEmWarehousesRequest;
import com.oracle.bmc.emwarehouse.requests.ListEtlRunsRequest;
import com.oracle.bmc.emwarehouse.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.emwarehouse.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.emwarehouse.requests.ListWorkRequestsRequest;
import com.oracle.bmc.emwarehouse.responses.ListEmWarehousesResponse;
import com.oracle.bmc.emwarehouse.responses.ListEtlRunsResponse;
import com.oracle.bmc.emwarehouse.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.emwarehouse.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.emwarehouse.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class EmWarehousePaginators {
    private final EmWarehouse client;

    public EmWarehousePaginators(EmWarehouse client) {
        this.client = client;
    }

    public Iterable<ListEmWarehousesResponse> listEmWarehousesResponseIterator(final ListEmWarehousesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEmWarehousesRequest.Builder>(){

            @Override
            public ListEmWarehousesRequest.Builder get() {
                return ListEmWarehousesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEmWarehousesResponse, String>(){

            @Override
            public String apply(ListEmWarehousesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEmWarehousesRequest.Builder>, ListEmWarehousesRequest>(){

            @Override
            public ListEmWarehousesRequest apply(RequestBuilderAndToken<ListEmWarehousesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEmWarehousesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEmWarehousesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEmWarehousesRequest, ListEmWarehousesResponse>(){

            @Override
            public ListEmWarehousesResponse apply(ListEmWarehousesRequest request) {
                return EmWarehousePaginators.this.client.listEmWarehouses(request);
            }
        });
    }

    public Iterable<EmWarehouseSummary> listEmWarehousesRecordIterator(final ListEmWarehousesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEmWarehousesRequest.Builder>(){

            @Override
            public ListEmWarehousesRequest.Builder get() {
                return ListEmWarehousesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEmWarehousesResponse, String>(){

            @Override
            public String apply(ListEmWarehousesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEmWarehousesRequest.Builder>, ListEmWarehousesRequest>(){

            @Override
            public ListEmWarehousesRequest apply(RequestBuilderAndToken<ListEmWarehousesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEmWarehousesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEmWarehousesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEmWarehousesRequest, ListEmWarehousesResponse>(){

            @Override
            public ListEmWarehousesResponse apply(ListEmWarehousesRequest request) {
                return EmWarehousePaginators.this.client.listEmWarehouses(request);
            }
        }, (Function)new Function<ListEmWarehousesResponse, List<EmWarehouseSummary>>(){

            @Override
            public List<EmWarehouseSummary> apply(ListEmWarehousesResponse response) {
                return response.getEmWarehouseCollection().getItems();
            }
        });
    }

    public Iterable<ListEtlRunsResponse> listEtlRunsResponseIterator(final ListEtlRunsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEtlRunsRequest.Builder>(){

            @Override
            public ListEtlRunsRequest.Builder get() {
                return ListEtlRunsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEtlRunsResponse, String>(){

            @Override
            public String apply(ListEtlRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEtlRunsRequest.Builder>, ListEtlRunsRequest>(){

            @Override
            public ListEtlRunsRequest apply(RequestBuilderAndToken<ListEtlRunsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEtlRunsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEtlRunsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEtlRunsRequest, ListEtlRunsResponse>(){

            @Override
            public ListEtlRunsResponse apply(ListEtlRunsRequest request) {
                return EmWarehousePaginators.this.client.listEtlRuns(request);
            }
        });
    }

    public Iterable<EtlRunSummary> listEtlRunsRecordIterator(final ListEtlRunsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEtlRunsRequest.Builder>(){

            @Override
            public ListEtlRunsRequest.Builder get() {
                return ListEtlRunsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEtlRunsResponse, String>(){

            @Override
            public String apply(ListEtlRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEtlRunsRequest.Builder>, ListEtlRunsRequest>(){

            @Override
            public ListEtlRunsRequest apply(RequestBuilderAndToken<ListEtlRunsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEtlRunsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEtlRunsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEtlRunsRequest, ListEtlRunsResponse>(){

            @Override
            public ListEtlRunsResponse apply(ListEtlRunsRequest request) {
                return EmWarehousePaginators.this.client.listEtlRuns(request);
            }
        }, (Function)new Function<ListEtlRunsResponse, List<EtlRunSummary>>(){

            @Override
            public List<EtlRunSummary> apply(ListEtlRunsResponse response) {
                return response.getEtlRunCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return EmWarehousePaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return EmWarehousePaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return EmWarehousePaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return EmWarehousePaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return EmWarehousePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return EmWarehousePaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

