/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.email.model.UpdateSenderDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateSenderRequest
extends BmcRequest<UpdateSenderDetails> {
    private String senderId;
    private UpdateSenderDetails updateSenderDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getSenderId() {
        return this.senderId;
    }

    public UpdateSenderDetails getUpdateSenderDetails() {
        return this.updateSenderDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateSenderDetails getBody$() {
        return this.updateSenderDetails;
    }

    public Builder toBuilder() {
        return new Builder().senderId(this.senderId).updateSenderDetails(this.updateSenderDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",senderId=").append(String.valueOf(this.senderId));
        sb.append(",updateSenderDetails=").append(String.valueOf((Object)this.updateSenderDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSenderRequest)) {
            return false;
        }
        UpdateSenderRequest other = (UpdateSenderRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.senderId, other.senderId) && Objects.equals((Object)this.updateSenderDetails, (Object)other.updateSenderDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.senderId == null ? 43 : this.senderId.hashCode());
        result = result * 59 + (this.updateSenderDetails == null ? 43 : this.updateSenderDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateSenderRequest, UpdateSenderDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String senderId = null;
        private UpdateSenderDetails updateSenderDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public Builder updateSenderDetails(UpdateSenderDetails updateSenderDetails) {
            this.updateSenderDetails = updateSenderDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSenderRequest o) {
            this.senderId(o.getSenderId());
            this.updateSenderDetails(o.getUpdateSenderDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSenderRequest build() {
            UpdateSenderRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateSenderDetails body) {
            this.updateSenderDetails(body);
            return this;
        }

        public UpdateSenderRequest buildWithoutInvocationCallback() {
            UpdateSenderRequest request = new UpdateSenderRequest();
            request.senderId = this.senderId;
            request.updateSenderDetails = this.updateSenderDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

